/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.sender.callback;

import com.datarangers.config.RangersJSONConfig;
import com.datarangers.logger.RangersLoggerWriter;
import com.datarangers.sender.Callback;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCallback
implements Callback {
    public static final Logger logger = LoggerFactory.getLogger(LoggingCallback.class);
    private static RangersLoggerWriter writer;
    private static final Object lock;

    public LoggingCallback(String targetPrefix, String targetName, int maxSize) {
        LoggingCallback.initWriter(targetPrefix, targetName, maxSize);
    }

    @Override
    public void onFailed(Callback.FailedData failedData) {
        if (failedData.getMessage() == null) {
            return;
        }
        if (!failedData.isListable()) {
            this.writeFailedMessage(failedData.getMessage());
        } else {
            try {
                List list = RangersJSONConfig.getInstance().fromJson(failedData.getMessage(), List.class);
                list.forEach(n -> this.writeFailedMessage(RangersJSONConfig.getInstance().toJson(n)));
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("json error", (Throwable)e);
                this.writeFailedMessage(failedData.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFailedMessage(String message) {
        RangersLoggerWriter rangersLoggerWriter = writer;
        synchronized (rangersLoggerWriter) {
            writer.write(message + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initWriter(String targetPrefix, String targetName, int maxSize) {
        if (writer == null) {
            Object object = lock;
            synchronized (object) {
                if (writer == null) {
                    writer = RangersLoggerWriter.getInstance(targetPrefix, targetName, maxSize);
                }
            }
        }
    }

    static {
        lock = new Object();
    }
}

