/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.sender.saasnative;

import com.datarangers.config.DataRangersSDKConfigProperties;
import com.datarangers.config.EventConfig;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.message.AppMessage;
import com.datarangers.message.Message;
import com.datarangers.sender.MessageSender;
import com.datarangers.util.HttpUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SaasNativeMessageSender
implements MessageSender {
    @Override
    public void send(Message message, DataRangersSDKConfigProperties sdkConfigProperties) {
        AppMessage sendMessage = SaasNativeMessageSender.getSassNativeMessage(message);
        Map<String, String> headers = this.getHeaders(message, sdkConfigProperties);
        HttpUtils.post(EventConfig.getAppUrl(), RangersJSONConfig.getInstance().toJson(sendMessage), headers);
    }

    @Override
    public void sendBatch(List<Message> message, DataRangersSDKConfigProperties sdkConfigProperties) {
        Map<String, String> headers = this.getHeaders(message.get(0), sdkConfigProperties);
        List sendMessages = message.stream().map(n -> SaasNativeMessageSender.getSassNativeMessage(n)).collect(Collectors.toList());
        HttpUtils.post(EventConfig.getAppListUrl(), RangersJSONConfig.getInstance().toJson(sendMessages), headers);
    }

    private Map<String, String> getHeaders(Message message, DataRangersSDKConfigProperties sdkConfigProperties) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(EventConfig.SEND_HEADER);
        Integer appId = message.getAppMessage().getAppId();
        Map<Integer, String> appKeys = sdkConfigProperties.getAppKeys();
        String appKey = appKeys.get(appId);
        if (appKey == null) {
            throw new IllegalArgumentException("App key cannot be empty. app_id: " + appId);
        }
        headers.put("X-MCS-AppKey", appKey);
        return headers;
    }

    public static AppMessage getSassNativeMessage(Message message) {
        AppMessage cloneAppMessage = message.getAppMessage().clone();
        cloneAppMessage.setAppId(null);
        cloneAppMessage.getHeader().setAppId(null);
        return cloneAppMessage;
    }
}

