/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class RuntimeMetric {
    private final String name;
    private final AtomicLong sum = new AtomicLong();
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);

    public RuntimeMetric(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public static RuntimeMetric copyOf(RuntimeMetric metric) {
        Objects.requireNonNull(metric, "metric is null");
        return new RuntimeMetric(metric.getName(), metric.getSum(), metric.getCount(), metric.getMax(), metric.getMin());
    }

    @JsonCreator
    public RuntimeMetric(@JsonProperty(value="name") String name, @JsonProperty(value="sum") long sum, @JsonProperty(value="count") long count, @JsonProperty(value="max") long max, @JsonProperty(value="min") long min) {
        this(name);
        this.set(sum, count, max, min);
    }

    private void set(long sum, long count, long max, long min) {
        this.sum.set(sum);
        this.count.set(count);
        this.max.set(max);
        this.min.set(min);
    }

    public void set(RuntimeMetric metric) {
        Objects.requireNonNull(metric, "metric is null");
        this.set(metric.getSum(), metric.getCount(), metric.getMax(), metric.getMin());
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void addValue(long value) {
        this.sum.addAndGet(value);
        this.count.incrementAndGet();
        this.max.accumulateAndGet(value, Math::max);
        this.min.accumulateAndGet(value, Math::min);
    }

    public static RuntimeMetric merge(RuntimeMetric metric1, RuntimeMetric metric2) {
        if (metric1 == null) {
            return metric2;
        }
        if (metric2 == null) {
            return metric1;
        }
        RuntimeMetric mergedMetric = RuntimeMetric.copyOf(metric1);
        mergedMetric.mergeWith(metric2);
        return mergedMetric;
    }

    public void mergeWith(RuntimeMetric metric) {
        if (metric == null) {
            return;
        }
        this.sum.addAndGet(metric.getSum());
        this.count.addAndGet(metric.getCount());
        this.max.accumulateAndGet(metric.getMax(), Math::max);
        this.min.accumulateAndGet(metric.getMin(), Math::min);
    }

    @JsonProperty
    public long getSum() {
        return this.sum.get();
    }

    @JsonProperty
    public long getCount() {
        return this.count.get();
    }

    @JsonProperty
    public long getMax() {
        return this.max.get();
    }

    @JsonProperty
    public long getMin() {
        return this.min.get();
    }
}

