/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.common.block.RunLengthEncodedBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Objects;

public class ColumnarArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ColumnarArray.class).instanceSize();
    private final Block nullCheckBlock;
    private final int offsetsOffset;
    private final int[] offsets;
    private final Block elementsBlock;
    private final long retainedSizeInBytes;
    private final long estimatedSerializedSizeInBytes;

    public static ColumnarArray toColumnarArray(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return ColumnarArray.toColumnarArray((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarArray.toColumnarArray((RunLengthEncodedBlock)block);
        }
        if (!(block instanceof AbstractArrayBlock)) {
            throw new IllegalArgumentException("Invalid array block: " + block.getClass().getName());
        }
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        Block elementsBlock = arrayBlock.getRawElementBlock();
        int elementsOffset = 0;
        int elementsLength = 0;
        if (arrayBlock.getPositionCount() > 0) {
            elementsOffset = arrayBlock.getOffset(0);
            elementsLength = arrayBlock.getOffset(arrayBlock.getPositionCount()) - elementsOffset;
        }
        elementsBlock = elementsBlock.getRegion(elementsOffset, elementsLength);
        return new ColumnarArray(block, arrayBlock.getOffsetBase(), arrayBlock.getOffsets(), elementsBlock, (long)INSTANCE_SIZE + block.getRetainedSizeInBytes(), block.getSizeInBytes());
    }

    private static ColumnarArray toColumnarArray(DictionaryBlock dictionaryBlock) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray(dictionaryBlock.getDictionary());
        int positionCount = dictionaryBlock.getPositionCount();
        int[] offsets = new int[positionCount + 1];
        for (int position = 0; position < positionCount; ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            offsets[position + 1] = offsets[position] + columnarArray.getLength(dictionaryId);
        }
        int[] dictionaryIds = new int[offsets[positionCount]];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < positionCount; ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            int length = columnarArray.getLength(dictionaryId);
            int startOffset = columnarArray.getOffset(dictionaryId);
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                dictionaryIds[nextDictionaryIndex] = startOffset + entryIndex;
                ++nextDictionaryIndex;
            }
        }
        Block elementsBlock = columnarArray.getElementsBlock();
        return new ColumnarArray(dictionaryBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, elementsBlock, dictionaryIds), (long)INSTANCE_SIZE + dictionaryBlock.getRetainedSizeInBytes() + SizeOf.sizeOf(offsets) + SizeOf.sizeOf(dictionaryIds), 5 * positionCount + elementsBlock.getPositionCount() == 0 ? 0L : (long)((double)elementsBlock.getSizeInBytes() / (double)elementsBlock.getPositionCount() * (double)offsets[positionCount]));
    }

    private static ColumnarArray toColumnarArray(RunLengthEncodedBlock rleBlock) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray(rleBlock.getValue());
        int positionCount = rleBlock.getPositionCount();
        int[] offsets = new int[positionCount + 1];
        int valueLength = columnarArray.getLength(0);
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i * valueLength;
        }
        int[] dictionaryIds = new int[positionCount * valueLength];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < positionCount; ++position) {
            int entryIndex = 0;
            while (entryIndex < valueLength) {
                dictionaryIds[nextDictionaryIndex] = entryIndex++;
                ++nextDictionaryIndex;
            }
        }
        Block elementsBlock = columnarArray.getElementsBlock();
        return new ColumnarArray(rleBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, elementsBlock, dictionaryIds), (long)INSTANCE_SIZE + rleBlock.getRetainedSizeInBytes() + SizeOf.sizeOf(offsets) + SizeOf.sizeOf(dictionaryIds), (long)(5 * positionCount) + (long)((double)elementsBlock.getSizeInBytes() / (double)elementsBlock.getPositionCount() * (double)offsets[positionCount]));
    }

    private ColumnarArray(Block nullCheckBlock, int offsetsOffset, int[] offsets, Block elementsBlock, long retainedSizeInBytes, long estimatedSerializedSizeInBytes) {
        this.nullCheckBlock = nullCheckBlock;
        this.offsetsOffset = offsetsOffset;
        this.offsets = offsets;
        this.elementsBlock = elementsBlock;
        this.retainedSizeInBytes = retainedSizeInBytes;
        this.estimatedSerializedSizeInBytes = estimatedSerializedSizeInBytes;
    }

    public int getPositionCount() {
        return this.nullCheckBlock.getPositionCount();
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock.isNull(position);
    }

    public int getLength(int position) {
        return this.offsets[position + 1 + this.offsetsOffset] - this.offsets[position + this.offsetsOffset];
    }

    public int getOffset(int position) {
        return this.offsets[position + this.offsetsOffset] - this.offsets[this.offsetsOffset];
    }

    public Block getElementsBlock() {
        return this.elementsBlock;
    }

    public Block getNullCheckBlock() {
        return this.nullCheckBlock;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getEstimatedSerializedSizeInBytes() {
        return this.estimatedSerializedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("positionCount=").append(this.getPositionCount()).append(",");
        sb.append("offsetsOffset=").append(this.offsetsOffset).append(",");
        sb.append("nullCheckBlock=").append(this.nullCheckBlock.toString()).append(",");
        sb.append("elementsBlock=").append(this.elementsBlock.toString()).append(",");
        sb.append('}');
        return sb.toString();
    }
}

