/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractRowBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.common.block.RunLengthEncodedBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Objects;

public final class ColumnarRow {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ColumnarRow.class).instanceSize();
    private final Block nullCheckBlock;
    private final Block[] fields;
    private final long retainedSizeInBytes;
    private final long estimatedSerializedSizeInBytes;

    public static ColumnarRow toColumnarRow(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return ColumnarRow.toColumnarRow((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarRow.toColumnarRow((RunLengthEncodedBlock)block);
        }
        if (!(block instanceof AbstractRowBlock)) {
            throw new IllegalArgumentException("Invalid row block: " + block.getClass().getName());
        }
        AbstractRowBlock rowBlock = (AbstractRowBlock)block;
        int firstRowPosition = rowBlock.getFieldBlockOffset(0);
        int totalRowCount = rowBlock.getFieldBlockOffset(block.getPositionCount()) - firstRowPosition;
        Block[] fieldBlocks = new Block[rowBlock.numFields];
        for (int i = 0; i < fieldBlocks.length; ++i) {
            fieldBlocks[i] = rowBlock.getRawFieldBlocks()[i].getRegion(firstRowPosition, totalRowCount);
        }
        return new ColumnarRow(block, fieldBlocks, block.getRetainedSizeInBytes(), block.getSizeInBytes());
    }

    private static ColumnarRow toColumnarRow(DictionaryBlock dictionaryBlock) {
        Block dictionary = dictionaryBlock.getDictionary();
        int[] newDictionaryIndex = new int[dictionary.getPositionCount()];
        int nextNewDictionaryIndex = 0;
        for (int position = 0; position < dictionary.getPositionCount(); ++position) {
            if (dictionary.isNull(position)) continue;
            newDictionaryIndex[position] = nextNewDictionaryIndex++;
        }
        int positionCount = dictionaryBlock.getPositionCount();
        int[] dictionaryIds = new int[positionCount];
        int nonNullPositionCount = 0;
        for (int position = 0; position < positionCount; ++position) {
            if (dictionaryBlock.isNull(position)) continue;
            int oldDictionaryId = dictionaryBlock.getId(position);
            dictionaryIds[nonNullPositionCount] = newDictionaryIndex[oldDictionaryId];
            ++nonNullPositionCount;
        }
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(dictionary);
        Block[] fields = new Block[columnarRow.getFieldCount()];
        long averageRowSize = 0L;
        for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
            Block field = columnarRow.getField(i);
            fields[i] = new DictionaryBlock(nonNullPositionCount, field, dictionaryIds);
            averageRowSize += field.getPositionCount() == 0 ? 0L : field.getSizeInBytes() / (long)field.getPositionCount();
        }
        return new ColumnarRow(dictionaryBlock, fields, (long)INSTANCE_SIZE + dictionaryBlock.getRetainedSizeInBytes() + SizeOf.sizeOf(dictionaryIds), (long)(5 * positionCount) + averageRowSize * (long)nonNullPositionCount);
    }

    private static ColumnarRow toColumnarRow(RunLengthEncodedBlock rleBlock) {
        Block rleValue = rleBlock.getValue();
        int positionCount = rleBlock.getPositionCount();
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow(rleValue);
        Block[] fields = new Block[columnarRow.getFieldCount()];
        long averageRowSize = 0L;
        for (int i = 0; i < columnarRow.getFieldCount(); ++i) {
            Block nullSuppressedField = columnarRow.getField(i);
            if (rleValue.isNull(0)) {
                if (nullSuppressedField.getPositionCount() != 0) {
                    throw new IllegalArgumentException("Invalid row block");
                }
                fields[i] = nullSuppressedField;
                continue;
            }
            fields[i] = new RunLengthEncodedBlock(nullSuppressedField, positionCount);
            averageRowSize += nullSuppressedField.getSizeInBytes() / (long)nullSuppressedField.getPositionCount();
        }
        return new ColumnarRow(rleBlock, fields, (long)INSTANCE_SIZE + rleBlock.getRetainedSizeInBytes(), (long)(5 * positionCount) + averageRowSize * (long)positionCount);
    }

    private ColumnarRow(Block nullCheckBlock, Block[] fields, long retainedSizeInBytes, long estimatedSerializedSizeInBytes) {
        this.nullCheckBlock = nullCheckBlock;
        this.fields = (Block[])fields.clone();
        this.retainedSizeInBytes = retainedSizeInBytes;
        this.estimatedSerializedSizeInBytes = estimatedSerializedSizeInBytes;
    }

    public int getPositionCount() {
        return this.nullCheckBlock.getPositionCount();
    }

    public int getNonNullPositionCount() {
        if (!this.nullCheckBlock.mayHaveNull()) {
            return this.getPositionCount();
        }
        int count = 0;
        for (int i = 0; i < this.getPositionCount(); ++i) {
            if (this.isNull(i)) continue;
            ++count;
        }
        return count;
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock.isNull(position);
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public Block getField(int index) {
        return this.fields[index];
    }

    public int getOffset(int position) {
        return ((AbstractRowBlock)this.nullCheckBlock).getFieldBlockOffset(position);
    }

    public Block getNullCheckBlock() {
        return this.nullCheckBlock;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getEstimatedSerializedSizeInBytes() {
        return this.estimatedSerializedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("positionCount=").append(this.getPositionCount()).append(",");
        sb.append("fieldsCount=").append(this.fields.length).append(",");
        for (int i = 0; i < this.fields.length; ++i) {
            sb.append("field_").append(i).append("=").append(this.fields[i].toString()).append(",");
        }
        sb.append('}');
        return sb.toString();
    }
}

