/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.memory;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.QueryId;
import com.facebook.presto.jdbc.internal.spi.memory.MemoryAllocation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ThriftStruct
public final class MemoryPoolInfo {
    private final long maxBytes;
    private final long reservedBytes;
    private final long reservedRevocableBytes;
    private final Map<QueryId, Long> queryMemoryReservations;
    private final Map<QueryId, List<MemoryAllocation>> queryMemoryAllocations;
    private final Map<QueryId, Long> queryMemoryRevocableReservations;

    @ThriftConstructor
    @JsonCreator
    public MemoryPoolInfo(@JsonProperty(value="maxBytes") long maxBytes, @JsonProperty(value="reservedBytes") long reservedBytes, @JsonProperty(value="reservedRevocableBytes") long reservedRevocableBytes, @JsonProperty(value="queryMemoryReservations") Map<QueryId, Long> queryMemoryReservations, @JsonProperty(value="queryMemoryAllocations") Map<QueryId, List<MemoryAllocation>> queryMemoryAllocations, @JsonProperty(value="queryMemoryRevocableReservations") Map<QueryId, Long> queryMemoryRevocableReservations) {
        this.maxBytes = maxBytes;
        this.reservedBytes = reservedBytes;
        this.reservedRevocableBytes = reservedRevocableBytes;
        this.queryMemoryReservations = Collections.unmodifiableMap(new HashMap<QueryId, Long>(queryMemoryReservations));
        this.queryMemoryAllocations = Collections.unmodifiableMap(new HashMap<QueryId, List<MemoryAllocation>>(queryMemoryAllocations));
        this.queryMemoryRevocableReservations = Collections.unmodifiableMap(new HashMap<QueryId, Long>(queryMemoryRevocableReservations));
    }

    @ThriftField(value=1)
    @JsonProperty
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @ThriftField(value=2)
    @JsonProperty
    public long getFreeBytes() {
        return this.maxBytes - this.reservedBytes - this.reservedRevocableBytes;
    }

    @ThriftField(value=3)
    @JsonProperty
    public long getReservedBytes() {
        return this.reservedBytes;
    }

    @ThriftField(value=4)
    @JsonProperty
    public long getReservedRevocableBytes() {
        return this.reservedRevocableBytes;
    }

    @ThriftField(value=5)
    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryReservations() {
        return this.queryMemoryReservations;
    }

    @ThriftField(value=6)
    @JsonProperty
    public Map<QueryId, List<MemoryAllocation>> getQueryMemoryAllocations() {
        return this.queryMemoryAllocations;
    }

    @ThriftField(value=7)
    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryRevocableReservations() {
        return this.queryMemoryRevocableReservations;
    }

    public String toString() {
        return String.format("maxBytes=%s,reservedBytes=%s,reserveRevocableBytes=%s", this.maxBytes, this.reservedBytes, this.reservedRevocableBytes);
    }
}

