/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.security.PrincipalType;
import java.util.Locale;
import java.util.Objects;

public class PrestoPrincipal {
    private final PrincipalType type;
    private final String name;

    @JsonCreator
    public PrestoPrincipal(@JsonProperty(value="type") PrincipalType type, @JsonProperty(value="name") String name) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null").toLowerCase(Locale.ENGLISH);
    }

    @JsonProperty
    public PrincipalType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrestoPrincipal prestoPrincipal = (PrestoPrincipal)o;
        return this.type == prestoPrincipal.type && Objects.equals(this.name, prestoPrincipal.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.name;
    }
}

