/*
 * Decompiled with CFR 0.152.
 */
package com.fundebug;

import com.fundebug.Event;
import com.fundebug.ExceptionHandler;
import java.util.List;
import java.util.Map;

public class Fundebug {
    private Event event;

    public Fundebug(String apiKey) {
        if (apiKey == null) {
            throw new NullPointerException("\u8bf7\u8bbe\u7f6eapiKey");
        }
        this.event = new Event(apiKey);
        ExceptionHandler.enableFundebugHandler(this.event);
    }

    public void notifyError(Throwable e) {
        this.event.notifyError(e);
    }

    public void notify(String name, String message) {
        this.event.notify(name, message);
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.event.setMetaData(metaData);
    }

    public void setReleaseStage(String releaseStage) {
        this.event.setReleaseStage(releaseStage);
    }

    public void setSilent(Boolean silent) {
        this.event.setSilent(silent);
    }

    public void setAppVersion(String appVersion) {
        this.event.setAppVersion(appVersion);
    }

    public void setFilters(List<Map<String, String>> filters) {
        this.event.setFilters(filters);
    }

    public void disable() {
        ExceptionHandler.disableFundebugHandler();
    }
}

