/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.api.internal.mapping;

import com.aliyun.api.AliyunResponse;
import com.taobao.api.ApiException;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.internal.mapping.Reader;
import com.taobao.api.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Set<String> baseFields = new HashSet<String>();
    private static final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws ApiException {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                Object value;
                ApiListField jsonListField;
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                String itemName = pd.getName();
                String listName = null;
                Field field = baseFields.contains(itemName) && AliyunResponse.class.isAssignableFrom(clazz) ? Converters.getField(AliyunResponse.class, pd) : Converters.getField(clazz, pd);
                ApiField jsonField = field.getAnnotation(ApiField.class);
                if (jsonField != null) {
                    itemName = jsonField.value();
                }
                if ((jsonListField = field.getAnnotation(ApiListField.class)) != null) {
                    listName = jsonListField.value();
                }
                if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                Class<?> typeClass = field.getType();
                if (String.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof String) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a String");
                    }
                    if (value != null) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    method.invoke(rsp, "");
                    continue;
                }
                if (Long.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Long) {
                        method.invoke(rsp, (Long)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Number(Long)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Long.valueOf(value.toString()));
                    continue;
                }
                if (Integer.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Integer) {
                        method.invoke(rsp, (Integer)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Number(Integer)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Integer.valueOf(value.toString()));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Boolean) {
                        method.invoke(rsp, (Boolean)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Boolean");
                    }
                    if (value == null) continue;
                    method.invoke(rsp, Boolean.valueOf(value.toString()));
                    continue;
                }
                if (Double.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Double) {
                        method.invoke(rsp, (Double)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new ApiException(itemName + " is not a Double");
                }
                if (Number.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Number) {
                        method.invoke(rsp, (Number)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new ApiException(itemName + " is not a Number");
                }
                if (Date.class.isAssignableFrom(typeClass)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                    Object value2 = reader.getPrimitiveObject(itemName);
                    if (!(value2 instanceof String)) continue;
                    method.invoke(rsp, format.parse(value2.toString()));
                    continue;
                }
                if (List.class.isAssignableFrom(typeClass)) {
                    Class subType;
                    List<?> listObjs;
                    ParameterizedType paramType;
                    Type[] genericTypes;
                    Type fieldType = field.getGenericType();
                    if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                    method.invoke(rsp, listObjs);
                    continue;
                }
                Object obj = reader.getObject(itemName, typeClass);
                if (obj == null) continue;
                method.invoke(rsp, obj);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return rsp;
    }

    private static Field getField(Class<?> clazz, PropertyDescriptor pd) throws Exception {
        String key = clazz.getName() + "_" + pd.getName();
        Field field = fieldCache.get(key);
        if (field == null) {
            field = clazz.getDeclaredField(pd.getName());
            fieldCache.put(key, field);
        }
        return field;
    }

    static {
        baseFields.add("errorCode");
        baseFields.add("message");
        baseFields.add("body");
        baseFields.add("params");
        baseFields.add("success");
    }
}

