/*
 * Decompiled with CFR 0.152.
 */
package com.dsk.acc.openapi.api;

import com.dsk.acc.openapi.client.Client;
import com.dsk.acc.openapi.client.Config;
import com.dsk.acc.openapi.client.bean.OpenApiRequest;
import com.dsk.acc.openapi.client.bean.Params;
import com.dsk.acc.openapi.client.bean.RuntimeOptions;
import com.dsk.acc.openapi.client.core.AccConverter;
import com.dsk.acc.openapi.client.core.AccPair;
import com.dsk.acc.openapi.client.exception.AccValidException;
import com.dsk.acc.openapi.client.util.CommonUtils;
import java.util.Map;

public class AccClient {
    private static Client client;
    private static String version;
    private static String OPENAPI_ENDPOINT;

    private AccClient() {
    }

    public static void init(Config config) {
        try {
            if (config.getEndpoint() == null) {
                config.setEndpoint(OPENAPI_ENDPOINT);
            }
            if (client == null) {
                client = new Client(config);
            }
        }
        catch (Exception e) {
            throw new AccValidException("client config init error", e);
        }
    }

    public static Map<String, ?> request(String reqBodyType, String pathname, Map<String, Object> reqBody) {
        if (client == null) {
            throw new AccValidException("client not init");
        }
        Map<String, ?> callApi = null;
        try {
            OpenApiRequest req = OpenApiRequest.build(AccConverter.buildMap(new AccPair("body", reqBody)));
            Params params = new Params().setAction(pathname).setPathname(pathname).setAuthType("AK").setBodyType("json").setReqBodyType(CommonUtils.defaultString(reqBodyType, "json")).setMethod("POST").setProtocol("HTTPS").setVersion(version).setStyle("ROA");
            callApi = client.callApi(params, req, new RuntimeOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return callApi;
    }

    public static Map<String, ?> request(String reqBodyType, String pathname, Map<String, Object> reqBody, Map<String, String> headers) {
        if (client == null) {
            throw new AccValidException("client not init");
        }
        Map<String, ?> callApi = null;
        try {
            OpenApiRequest req = OpenApiRequest.build(AccConverter.buildMap(new AccPair("body", reqBody)), headers);
            Params params = new Params().setAction(pathname).setPathname(pathname).setAuthType("AK").setBodyType("json").setReqBodyType(CommonUtils.defaultString(reqBodyType, "json")).setMethod("POST").setProtocol("HTTPS").setVersion(version).setStyle("ROA");
            callApi = client.callApi(params, req, new RuntimeOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return callApi;
    }

    static {
        version = "1.0.4";
        OPENAPI_ENDPOINT = "openapi.jiansheku.com";
    }
}

