/*
 * Decompiled with CFR 0.152.
 */
package com.dsk.acc.openapi.client.util.okhttp;

import com.dsk.acc.openapi.client.core.AccRequest;
import com.dsk.acc.openapi.client.util.okhttp.OkRequestBody;
import java.net.URL;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkRequestBuilder {
    private Request.Builder builder;

    public OkRequestBuilder(Request.Builder builder) {
        this.builder = builder;
    }

    public OkRequestBuilder url(URL url) {
        this.builder.url(url);
        return this;
    }

    public OkRequestBuilder header(Map<String, String> headers) {
        for (String headerName : headers.keySet()) {
            this.builder.header(headerName, headers.get(headerName));
        }
        return this;
    }

    private static String getAppkey(String authorization) {
        if (authorization == null || !authorization.contains("Credential=")) {
            return null;
        }
        int appKeyBeg = authorization.indexOf("=") + 1;
        int appKeyEnd = authorization.indexOf(",");
        if (appKeyBeg < 1 || appKeyBeg > appKeyEnd) {
            return null;
        }
        String appKey = authorization.substring(appKeyBeg, appKeyEnd);
        return appKey;
    }

    public Request buildRequest(AccRequest request) {
        String method;
        switch (method = request.method.toUpperCase()) {
            case "DELETE": {
                this.builder.delete();
                break;
            }
            case "POST": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.post((RequestBody)requestBody);
                break;
            }
            case "PUT": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.put((RequestBody)requestBody);
                break;
            }
            case "PATCH": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.patch((RequestBody)requestBody);
                break;
            }
            default: {
                this.builder.get();
            }
        }
        return this.builder.build();
    }
}

