/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts;

import com.github.abel533.echarts.Basic;
import com.github.abel533.echarts.Component;
import com.github.abel533.echarts.code.Orient;
import com.github.abel533.echarts.code.Tool;
import com.github.abel533.echarts.feature.Feature;
import com.github.abel533.echarts.style.ItemStyle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Toolbox
extends Basic<Toolbox>
implements Component {
    private Map<String, Feature> feature;
    private Orient orient;
    private List<Object> color;
    private String disableColor;
    private String effectiveColor;
    private Integer itemSize;
    private Boolean showTitle;
    private ItemStyle iconStyle;

    public ItemStyle iconStyle() {
        return this.iconStyle;
    }

    public Toolbox iconStyle(ItemStyle iconStyle) {
        this.iconStyle = iconStyle;
        return this;
    }

    public Toolbox color(List<Object> color) {
        this.color = color;
        return this;
    }

    public Orient orient() {
        return this.orient;
    }

    public Toolbox orient(Orient orient) {
        this.orient = orient;
        return this;
    }

    public List<Object> color() {
        if (this.color == null) {
            this.color = new ArrayList<Object>();
        }
        return this.color;
    }

    public String disableColor() {
        return this.disableColor;
    }

    public Toolbox disableColor(String disableColor) {
        this.disableColor = disableColor;
        return this;
    }

    public String effectiveColor() {
        return this.effectiveColor;
    }

    public Toolbox effectiveColor(String effectiveColor) {
        this.effectiveColor = effectiveColor;
        return this;
    }

    public Integer itemSize() {
        return this.itemSize;
    }

    public Toolbox itemSize(Integer itemSize) {
        this.itemSize = itemSize;
        return this;
    }

    public Boolean showTitle() {
        return this.showTitle;
    }

    public Toolbox showTitle(Boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    public Map<String, Feature> feature() {
        if (this.feature == null) {
            this.feature = new LinkedHashMap<String, Feature>();
        }
        return this.feature;
    }

    private Toolbox _addFeature(Feature value) {
        if (value == null) {
            return this;
        }
        String name = value.getClass().getSimpleName();
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        this._addFeatureOnce(name, value);
        return this;
    }

    public Toolbox feature(Object ... values) {
        if (values == null && values.length == 0) {
            return this;
        }
        if (this.feature == null) {
            this.feature = new LinkedHashMap<String, Feature>();
        }
        block8: for (Object t : values) {
            if (t instanceof Feature) {
                this._addFeature((Feature)t);
                continue;
            }
            if (!(t instanceof Tool)) continue;
            switch ((Tool)((Object)t)) {
                case dataView: {
                    this._addFeatureOnce(t, Feature.dataView);
                    continue block8;
                }
                case dataZoom: {
                    this._addFeatureOnce(t, Feature.dataZoom);
                    continue block8;
                }
                case magicType: {
                    this._addFeatureOnce(t, Feature.magicType);
                    continue block8;
                }
                case mark: {
                    this._addFeatureOnce(t, Feature.mark);
                    continue block8;
                }
                case restore: {
                    this._addFeatureOnce(t, Feature.restore);
                    continue block8;
                }
                case saveAsImage: {
                    this._addFeatureOnce(t, Feature.saveAsImage);
                    continue block8;
                }
            }
        }
        return this;
    }

    private void _addFeatureOnce(Object name, Feature feature) {
        String _name = String.valueOf(name);
        if (!this.feature().containsKey(_name)) {
            this.feature().put(_name, feature);
        }
    }

    public Map<String, Feature> getFeature() {
        return this.feature;
    }

    public Orient getOrient() {
        return this.orient;
    }

    public List<Object> getColor() {
        return this.color;
    }

    public String getDisableColor() {
        return this.disableColor;
    }

    public String getEffectiveColor() {
        return this.effectiveColor;
    }

    public Integer getItemSize() {
        return this.itemSize;
    }

    public Boolean getShowTitle() {
        return this.showTitle;
    }

    public ItemStyle getIconStyle() {
        return this.iconStyle;
    }

    public void setFeature(Map<String, Feature> feature) {
        this.feature = feature;
    }

    public void setOrient(Orient orient) {
        this.orient = orient;
    }

    public void setColor(List<Object> color) {
        this.color = color;
    }

    public void setDisableColor(String disableColor) {
        this.disableColor = disableColor;
    }

    public void setEffectiveColor(String effectiveColor) {
        this.effectiveColor = effectiveColor;
    }

    public void setItemSize(Integer itemSize) {
        this.itemSize = itemSize;
    }

    public void setShowTitle(Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public void setIconStyle(ItemStyle iconStyle) {
        this.iconStyle = iconStyle;
    }
}

