/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts.json;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.json.AxisDeserializer;
import com.github.abel533.echarts.json.SeriesDeserializer;
import com.github.abel533.echarts.series.Series;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

public class GsonUtil {
    public static String format(Object object) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(gson.toJson(object));
        String prettyJsonString = gson.toJson(je);
        String[] lines = prettyJsonString.split("\n");
        lines = GsonUtil.replaceFunctionQuote(lines);
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public static String prettyFormat(Object object) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(gson.toJson(object));
        String prettyJsonString = gson.toJson(je);
        String[] lines = prettyJsonString.split("\n");
        lines = GsonUtil.replaceFunctionQuote(lines);
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            stringBuilder.append(line + "\n");
        }
        return stringBuilder.toString();
    }

    public static String[] replaceFunctionQuote(String[] lines) {
        boolean function = false;
        boolean immediately = false;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!function && line.contains("\"function")) {
                function = true;
                line = line.replaceAll("\"function", "function");
            }
            if (function && line.contains("}\"")) {
                function = false;
                line = line.replaceAll("\\}\"", "\\}");
            }
            if (!immediately && line.contains("\"(function")) {
                immediately = true;
                line = line.replaceAll("\"\\(function", "\\(function");
            }
            if (immediately && line.contains("})()\"")) {
                immediately = false;
                line = line.replaceAll("\\}\\)\\(\\)\"", "\\}\\)\\(\\)");
            }
            lines[i] = line;
        }
        return lines;
    }

    public static <T extends Option> T fromJSON(String json, Class<T> type) {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Series.class, (Object)new SeriesDeserializer()).registerTypeAdapter(Axis.class, (Object)new AxisDeserializer()).create();
        return (T)((Option)gson.fromJson(json, type));
    }

    public static Option fromJSON(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Series.class, (Object)new SeriesDeserializer()).registerTypeAdapter(Axis.class, (Object)new AxisDeserializer()).create();
        Option option = (Option)gson.fromJson(json, Option.class);
        return option;
    }

    public static void print(Object object) {
        System.out.println(GsonUtil.format(object));
    }

    public static void printPretty(Object object) {
        System.out.println(GsonUtil.prettyFormat(object));
    }
}

