/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.cp.api.WxCpChatService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpAppChatMessage;
import me.chanjar.weixin.cp.bean.WxCpChat;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxCpChatServiceImpl
implements WxCpChatService {
    private final WxCpService cpService;

    @Override
    public String create(String name, String owner, List<String> users, String chatId) throws WxErrorException {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            data.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            data.put("owner", owner);
        }
        if (users != null) {
            data.put("userlist", users);
        }
        if (StringUtils.isNotBlank((CharSequence)chatId)) {
            data.put("chatid", chatId);
        }
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/appchat/create");
        String result = this.cpService.post(url, WxGsonBuilder.create().toJson(data));
        return GsonParser.parse((String)result).get("chatid").getAsString();
    }

    @Override
    public void update(String chatId, String name, String owner, List<String> usersToAdd, List<String> usersToDelete) throws WxErrorException {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        if (StringUtils.isNotBlank((CharSequence)chatId)) {
            data.put("chatid", chatId);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            data.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            data.put("owner", owner);
        }
        if (usersToAdd != null && !usersToAdd.isEmpty()) {
            data.put("add_user_list", usersToAdd);
        }
        if (usersToDelete != null && !usersToDelete.isEmpty()) {
            data.put("del_user_list", usersToDelete);
        }
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/appchat/update");
        this.cpService.post(url, WxGsonBuilder.create().toJson(data));
    }

    @Override
    public WxCpChat get(String chatId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/appchat/get?chatid=" + chatId);
        String result = this.cpService.get(url, null);
        String chatInfo = GsonParser.parse((String)result).getAsJsonObject("chat_info").toString();
        return (WxCpChat)WxCpGsonBuilder.create().fromJson(chatInfo, WxCpChat.class);
    }

    @Override
    public void sendMsg(WxCpAppChatMessage message) throws WxErrorException {
        this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/appchat/send"), message.toJson());
    }

    public WxCpChatServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

