/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpGroupRobotService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpGroupRobotMessage;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;

public class WxCpGroupRobotServiceImpl
implements WxCpGroupRobotService {
    private final WxCpService cpService;

    private String getApiUrl() {
        WxCpConfigStorage wxCpConfigStorage = this.cpService.getWxCpConfigStorage();
        return wxCpConfigStorage.getApiUrl("/cgi-bin/webhook/send?key=") + wxCpConfigStorage.getWebhookKey();
    }

    @Override
    public void sendText(String content, List<String> mentionedList, List<String> mobileList) throws WxErrorException {
        WxCpGroupRobotMessage message = new WxCpGroupRobotMessage().setMsgType("text").setContent(content).setMentionedList(mentionedList).setMentionedMobileList(mobileList);
        this.cpService.postWithoutToken(this.getApiUrl(), message.toJson());
    }

    @Override
    public void sendMarkDown(String content) throws WxErrorException {
        WxCpGroupRobotMessage message = new WxCpGroupRobotMessage().setMsgType("markdown").setContent(content);
        this.cpService.postWithoutToken(this.getApiUrl(), message.toJson());
    }

    @Override
    public void sendImage(String base64, String md5) throws WxErrorException {
        WxCpGroupRobotMessage message = new WxCpGroupRobotMessage().setMsgType("image").setBase64(base64).setMd5(md5);
        this.cpService.postWithoutToken(this.getApiUrl(), message.toJson());
    }

    @Override
    public void sendNews(List<NewArticle> articleList) throws WxErrorException {
        WxCpGroupRobotMessage message = new WxCpGroupRobotMessage().setMsgType("news").setArticles(articleList);
        this.cpService.postWithoutToken(this.getApiUrl(), message.toJson());
    }

    public WxCpGroupRobotServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

