/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.impl.BaseWxCpTpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxCpTpServiceApacheHttpClientImpl
extends BaseWxCpTpServiceImpl<CloseableHttpClient, HttpHost> {
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.APACHE_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSuiteAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isSuiteAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getSuiteAccessToken();
        }
        Object object = this.globalSuiteAccessTokenRefreshLock;
        synchronized (object) {
            try {
                String resultContent;
                HttpPost httpPost = new HttpPost(this.configStorage.getApiUrl("/cgi-bin/service/get_suite_token"));
                if (this.httpProxy != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                    httpPost.setConfig(config);
                }
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("suite_id", this.configStorage.getSuiteId());
                jsonObject.addProperty("suite_secret", this.configStorage.getSuiteSecret());
                jsonObject.addProperty("suite_ticket", this.getSuiteTicket());
                StringEntity entity = new StringEntity(jsonObject.toString(), Consts.UTF_8);
                httpPost.setEntity((HttpEntity)entity);
                try (CloseableHttpClient httpclient = this.getRequestHttpClient();
                     CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                    resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                }
                finally {
                    httpPost.releaseConnection();
                }
                WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                jsonObject = GsonParser.parse((String)resultContent);
                String suiteAccussToken = jsonObject.get("suite_access_token").getAsString();
                Integer expiresIn = jsonObject.get("expires_in").getAsInt();
                this.configStorage.updateSuiteAccessToken(suiteAccussToken, expiresIn);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.configStorage.getSuiteAccessToken();
    }

    @Override
    public void initHttp() {
        ApacheHttpClientBuilder apacheHttpClientBuilder = this.configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(this.configStorage.getHttpProxyHost()).httpProxyPort(this.configStorage.getHttpProxyPort()).httpProxyUsername(this.configStorage.getHttpProxyUsername()).httpProxyPassword(this.configStorage.getHttpProxyPassword());
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public WxCpTpConfigStorage getWxCpTpConfigStorage() {
        return this.configStorage;
    }
}

