/*
 * Decompiled with CFR 0.152.
 */
package com.github.crab2died.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelTemplate {
    private Workbook workbook;
    private Sheet sheet;
    private int sheetIndex;
    private Row currentRow;
    private int currentColumnIndex;
    private int currentRowIndex;
    private CellStyle defaultStyle;
    private Map<Integer, CellStyle> appointLineStyle = new HashMap<Integer, CellStyle>();
    private Map<String, CellStyle> classifyStyle = new HashMap<String, CellStyle>();
    private CellStyle singleLineStyle;
    private CellStyle doubleLineStyle;
    private int initColumnIndex;
    private int initRowIndex;
    private int lastRowIndex;
    private float rowHeight;
    private int serialNumberColumnIndex = -1;
    private int serialNumber;

    private ExcelTemplate() {
    }

    public static ExcelTemplate getInstance(String templatePath, int sheetIndex) throws Exception {
        ExcelTemplate template = new ExcelTemplate();
        template.sheetIndex = sheetIndex;
        template.loadTemplate(templatePath);
        return template;
    }

    private void loadTemplate(String templatePath) throws IOException, InvalidFormatException {
        try {
            this.workbook = WorkbookFactory.create((File)new File(templatePath));
        }
        catch (IOException | InvalidFormatException e) {
            this.workbook = WorkbookFactory.create((InputStream)ExcelTemplate.class.getResourceAsStream(templatePath));
        }
        this.sheet = this.workbook.getSheetAt(this.sheetIndex);
        this.initModuleConfig();
        this.currentRowIndex = this.initRowIndex;
        this.currentColumnIndex = this.initColumnIndex;
        this.lastRowIndex = this.sheet.getLastRowNum();
    }

    private void initModuleConfig() {
        for (Row row : this.sheet) {
            for (Cell c : row) {
                if (c.getCellTypeEnum() != CellType.STRING) continue;
                String str = c.getStringCellValue().trim().toLowerCase();
                if ("$serial_number".equals(str)) {
                    this.serialNumberColumnIndex = c.getColumnIndex();
                }
                if ("$data_index".equals(str)) {
                    this.initColumnIndex = c.getColumnIndex();
                    this.initRowIndex = row.getRowNum();
                    this.rowHeight = row.getHeightInPoints();
                }
                this.initStyles(c, str);
            }
        }
    }

    private void initStyles(Cell cell, String moduleContext) {
        if (null == moduleContext || "".equals(moduleContext)) {
            return;
        }
        if (!moduleContext.startsWith("&")) {
            moduleContext = moduleContext.toLowerCase();
        }
        if ("$default_style".equals(moduleContext)) {
            this.defaultStyle = cell.getCellStyle();
            this.clearCell(cell);
        }
        if (moduleContext.startsWith("&") && moduleContext.length() > 1) {
            this.classifyStyle.put(moduleContext.substring(1), cell.getCellStyle());
            this.clearCell(cell);
        }
        if ("$appoint_line_style".equals(moduleContext)) {
            this.appointLineStyle.put(cell.getRowIndex(), cell.getCellStyle());
            this.clearCell(cell);
        }
        if ("$single_line_style".equals(moduleContext)) {
            this.singleLineStyle = cell.getCellStyle();
            this.clearCell(cell);
        }
        if ("$double_line_style".equals(moduleContext)) {
            this.doubleLineStyle = cell.getCellStyle();
            this.clearCell(cell);
        }
    }

    private void clearCell(Cell cell) {
        cell.setCellStyle(null);
        cell.setCellValue("");
    }

    public void extendData(Map<String, String> data) {
        if (data == null) {
            return;
        }
        for (Row row : this.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellTypeEnum() != CellType.STRING || !(str = c.getStringCellValue().trim()).startsWith("#") || !data.containsKey(str.substring(1))) continue;
                c.setCellValue(data.get(str.substring(1)));
            }
        }
    }

    public void createNewRow() {
        if (this.lastRowIndex > this.currentRowIndex && this.currentRowIndex != this.initRowIndex) {
            this.sheet.shiftRows(this.currentRowIndex, this.lastRowIndex, 1, true, true);
            ++this.lastRowIndex;
        }
        this.currentRow = this.sheet.createRow(this.currentRowIndex);
        this.currentRow.setHeightInPoints(this.rowHeight);
        ++this.currentRowIndex;
        this.currentColumnIndex = this.initColumnIndex;
    }

    public void insertSerial(String styleKey) {
        if (this.serialNumberColumnIndex < 0) {
            return;
        }
        ++this.serialNumber;
        Cell c = this.currentRow.createCell(this.serialNumberColumnIndex);
        this.setCellStyle(c, styleKey);
        c.setCellValue((double)this.serialNumber);
    }

    public void createCell(Object value, String styleKey) {
        Cell cell = this.currentRow.createCell(this.currentColumnIndex);
        this.setCellStyle(cell, styleKey);
        if (null == value || "".equals(value)) {
            ++this.currentColumnIndex;
            return;
        }
        if (String.class == value.getClass()) {
            cell.setCellValue((String)value);
            ++this.currentColumnIndex;
            return;
        }
        if (Integer.TYPE == value.getClass()) {
            cell.setCellValue((double)((Integer)value).intValue());
            ++this.currentColumnIndex;
            return;
        }
        if (Integer.class == value.getClass()) {
            cell.setCellValue((double)((Integer)value).intValue());
            ++this.currentColumnIndex;
            return;
        }
        if (Double.TYPE == value.getClass()) {
            cell.setCellValue(((Double)value).doubleValue());
            ++this.currentColumnIndex;
            return;
        }
        if (Double.class == value.getClass()) {
            cell.setCellValue(((Double)value).doubleValue());
            ++this.currentColumnIndex;
            return;
        }
        if (Date.class == value.getClass()) {
            cell.setCellValue((Date)value);
            ++this.currentColumnIndex;
            return;
        }
        if (Boolean.TYPE == value.getClass()) {
            cell.setCellValue(((Boolean)value).booleanValue());
            ++this.currentColumnIndex;
            return;
        }
        if (Boolean.class == value.getClass()) {
            cell.setCellValue(((Boolean)value).booleanValue());
            ++this.currentColumnIndex;
            return;
        }
        if (Calendar.class == value.getClass()) {
            cell.setCellValue((Calendar)value);
            ++this.currentColumnIndex;
            return;
        }
        ++this.currentColumnIndex;
    }

    private void setCellStyle(Cell cell, String styleKey) {
        if (null != styleKey && null != this.classifyStyle.get(styleKey)) {
            cell.setCellStyle(this.classifyStyle.get(styleKey));
            return;
        }
        if (null != this.appointLineStyle && this.appointLineStyle.containsKey(cell.getRowIndex())) {
            cell.setCellStyle(this.appointLineStyle.get(cell.getRowIndex()));
            return;
        }
        if (null != this.singleLineStyle && cell.getRowIndex() % 2 != 0) {
            cell.setCellStyle(this.singleLineStyle);
            return;
        }
        if (null != this.doubleLineStyle && cell.getRowIndex() % 2 == 0) {
            cell.setCellStyle(this.doubleLineStyle);
            return;
        }
        if (null != this.defaultStyle) {
            cell.setCellStyle(this.defaultStyle);
        }
    }

    public void write2File(String filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            this.workbook.write((OutputStream)fos);
        }
    }

    public void write2Stream(OutputStream os) throws IOException {
        this.workbook.write(os);
    }
}

