/*
 * Decompiled with CFR 0.152.
 */
package com.github.crab2died.utils;

import com.github.crab2died.annotation.ExcelField;
import com.github.crab2died.converter.DefaultConvertible;
import com.github.crab2died.converter.WriteConvertible;
import com.github.crab2died.handler.ExcelHeader;
import com.github.crab2died.utils.DateUtils;
import com.github.crab2died.utils.RegularUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class Utils {
    public static List<ExcelHeader> getHeaderList(Class<?> clz) throws IllegalAccessException, InstantiationException {
        ArrayList<ExcelHeader> headers = new ArrayList<ExcelHeader>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = clz; clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ExcelField.class)) continue;
            ExcelField er = field.getAnnotation(ExcelField.class);
            headers.add(new ExcelHeader(er.title(), er.order(), er.writeConverter().newInstance(), er.readConverter().newInstance(), field.getName(), field.getType()));
        }
        Collections.sort(headers);
        return headers;
    }

    public static Map<Integer, ExcelHeader> getHeaderMap(Row titleRow, Class<?> clz) throws InstantiationException, IllegalAccessException {
        List<ExcelHeader> headers = Utils.getHeaderList(clz);
        HashMap<Integer, ExcelHeader> maps = new HashMap<Integer, ExcelHeader>();
        block0: for (Cell c : titleRow) {
            String title = c.getStringCellValue();
            for (ExcelHeader eh : headers) {
                if (!eh.getTitle().equals(title.trim())) continue;
                maps.put(c.getColumnIndex(), eh);
                continue block0;
            }
        }
        return maps;
    }

    public static String getCellValue(Cell c) {
        String o;
        switch (c.getCellTypeEnum()) {
            case BLANK: {
                o = "";
                break;
            }
            case BOOLEAN: {
                o = String.valueOf(c.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                o = String.valueOf(c.getCellFormula());
                break;
            }
            case NUMERIC: {
                o = String.valueOf(c.getNumericCellValue());
                o = Utils.matchDoneBigDecimal(o);
                o = RegularUtils.converNumByReg(o);
                break;
            }
            case STRING: {
                o = c.getStringCellValue();
                break;
            }
            default: {
                o = null;
            }
        }
        return o;
    }

    public static Object str2TargetClass(String strField, Class<?> clazz) {
        if (null == strField || "".equals(strField)) {
            return null;
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            strField = RegularUtils.converNumByReg(strField);
            return Long.parseLong(strField);
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            strField = RegularUtils.converNumByReg(strField);
            return Integer.parseInt(strField);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            return Float.valueOf(Float.parseFloat(strField));
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            strField = Utils.matchDoneBigDecimal(strField);
            return Double.parseDouble(strField);
        }
        if (Character.class == clazz || Character.TYPE == clazz) {
            return Character.valueOf(strField.toCharArray()[0]);
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(strField);
        }
        if (Date.class == clazz) {
            return DateUtils.str2DateUnmatch2Null(strField);
        }
        return strField;
    }

    private static String matchDoneBigDecimal(String bigDecimal) {
        boolean flg = Pattern.matches("^-?\\d+(\\.\\d+)?(E-?\\d+)?$", bigDecimal);
        if (flg) {
            BigDecimal bd = new BigDecimal(bigDecimal);
            bigDecimal = bd.toPlainString();
        }
        return bigDecimal;
    }

    public static Method getterOrSetter(Class clazz, String fieldName, FieldAccessType methodType) throws IntrospectionException {
        PropertyDescriptor[] props;
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
            if (!fieldName.equals(prop.getName())) continue;
            if (FieldAccessType.SETTER == methodType) {
                return prop.getWriteMethod();
            }
            if (FieldAccessType.GETTER != methodType) continue;
            return prop.getReadMethod();
        }
        throw new IntrospectionException("Can not get the getter or setter method");
    }

    private static Field matchClassField(Class clazz, String fieldName) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        for (Field field : fields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static String getProperty(Object bean, String fieldName, WriteConvertible writeConvertible) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        if (bean == null || fieldName == null) {
            throw new IllegalArgumentException("Operating bean or filed class must not be null");
        }
        Method method = Utils.getterOrSetter(bean.getClass(), fieldName, FieldAccessType.GETTER);
        Object object = method.invoke(bean, new Object[0]);
        if (null != writeConvertible && writeConvertible.getClass() != DefaultConvertible.class) {
            object = writeConvertible.execWrite(object);
        }
        return object == null ? "" : object.toString();
    }

    public static void copyProperty(Object bean, String name, Object value) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        if (null == name || null == value) {
            return;
        }
        Field field = Utils.matchClassField(bean.getClass(), name);
        if (null == field) {
            return;
        }
        Method method = Utils.getterOrSetter(bean.getClass(), name, FieldAccessType.SETTER);
        if (value.getClass() == field.getType()) {
            method.invoke(bean, value);
        } else {
            method.invoke(bean, Utils.str2TargetClass(value.toString(), field.getType()));
        }
    }

    public static enum FieldAccessType {
        GETTER,
        SETTER;

    }
}

