/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.hibernate4.AbstractRedisRegionFactory;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonRedisRegionFactory
extends AbstractRedisRegionFactory {
    private static final Logger log = LoggerFactory.getLogger(SingletonRedisRegionFactory.class);
    private static final AtomicInteger ReferenceCount = new AtomicInteger();
    private static final long serialVersionUID = -7477946174209489184L;

    public SingletonRedisRegionFactory(Properties props) {
        super(props);
        log.info("Create SingletonRedisRegionFactory instance.");
    }

    public synchronized void start(Settings settings, Properties properties) throws CacheException {
        log.info("Starting SingletonRedisRegionFactory...");
        this.settings = settings;
        try {
            if (this.redis == null) {
                RedisCacheUtil.loadCacheProperties(properties);
                this.redis = this.createRedisClient();
                this.cacheTimestamper = this.createCacheTimestamper(this.redis, SingletonRedisRegionFactory.class.getName());
            }
            ReferenceCount.incrementAndGet();
            log.info("Started SingletonRedisRegionFactory");
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public synchronized void stop() {
        log.debug("Stopping SingletonRedisRegionFactory...");
        if (ReferenceCount.decrementAndGet() == 0) {
            try {
                this.redis.shutdown();
                this.redis = null;
                this.cacheTimestamper = null;
                log.info("stopped SingletonRedisRegionFactory");
            }
            catch (Exception ignored) {
                log.warn("Error occurred in stopping hibernate-redis client.", (Throwable)ignored);
            }
        }
    }
}

