/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate5.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.hibernate5.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate5.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRedisNaturalIdRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyRedisNaturalIdRegionAccessStrategy.class);

    public ReadOnlyRedisNaturalIdRegionAccessStrategy(RedisNaturalIdRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisNaturalIdRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(SessionImplementor session, Object key, Object version) {
        return null;
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) {
        ((RedisNaturalIdRegion)this.region).remove(key);
    }

    public boolean insert(SessionImplementor session, Object key, Object value) {
        return false;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) {
        ((RedisNaturalIdRegion)this.region).put(key, value);
        return true;
    }

    public boolean update(SessionImplementor session, Object key, Object value) {
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) {
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }
}

