/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.regions;

import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate52.ConfigurableRedisRegionFactory;
import org.hibernate.cache.redis.hibernate52.regions.RedisDataRegion;
import org.hibernate.cache.redis.hibernate52.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisTransactionalDataRegion
extends RedisDataRegion
implements TransactionalDataRegion {
    private static final Logger log = LoggerFactory.getLogger(RedisTransactionalDataRegion.class);
    protected final SessionFactoryOptions options;
    protected final CacheDataDescription metadata;

    public RedisTransactionalDataRegion(RedisAccessStrategyFactory accessStrategyFactory, RedisClient redis, ConfigurableRedisRegionFactory configurableRedisRegionFactory, String regionName, SessionFactoryOptions options, CacheDataDescription metadata, Properties props) {
        super(accessStrategyFactory, redis, configurableRedisRegionFactory, regionName, props);
        this.options = options;
        this.metadata = metadata;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public Object get(Object key) {
        try {
            return this.redis.get(this.getName(), key);
        }
        catch (Exception ignored) {
            log.warn("Fail to get cache item... key=" + key, (Throwable)ignored);
            return null;
        }
    }

    public void put(Object key, Object value) {
        try {
            this.redis.set(this.getName(), key, value, this.getExpiryInSeconds());
        }
        catch (Exception ignored) {
            log.warn("Fail to put cache item... key=" + key, (Throwable)ignored);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.redis.del(this.getName(), key);
        }
        catch (Exception ignored) {
            log.warn("Fail to remove cache item... key=" + key, (Throwable)ignored);
        }
    }

    public void clear() {
        try {
            this.redis.deleteRegion(this.getName());
        }
        catch (Exception ignored) {
            log.warn("Fail to clear region... name=" + this.getName(), (Throwable)ignored);
        }
    }

    public SessionFactoryOptions getOptions() {
        return this.options;
    }

    public CacheDataDescription getMetadata() {
        return this.metadata;
    }
}

