/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.retry;

class RetryStrategy {
    private int maxRetries;
    private final int intervalMs;

    public RetryStrategy(int maxRetries, int intervalMs) {
        this.maxRetries = maxRetries;
        this.intervalMs = intervalMs;
    }

    public boolean shouldRetry() {
        return this.maxRetries > 0;
    }

    public void retry() {
        --this.maxRetries;
        this.waitUntilNextTry();
    }

    private void waitUntilNextTry() {
        try {
            Thread.sleep(this.intervalMs);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

