/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.admin;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.admin.AutoLoadVO;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/autoload-cache"})
public class AutoloadCacheController {
    private static final Logger log = LoggerFactory.getLogger(AutoloadCacheController.class);
    private final CacheHandler autoloadCacheHandler;
    private static final ThreadLocal<SimpleDateFormat> FORMATER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public AutoloadCacheController(CacheHandler autoloadCacheHandler) {
        this.autoloadCacheHandler = autoloadCacheHandler;
    }

    @GetMapping
    public AutoLoadVO[] listAutoLoadVO() {
        AutoLoadTO[] queue = this.autoloadCacheHandler.getAutoLoadHandler().getAutoLoadQueue();
        if (null == queue || queue.length == 0) {
            return null;
        }
        AutoLoadVO[] autoLoadVOs = new AutoLoadVO[queue.length];
        for (int i = 0; i < queue.length; ++i) {
            AutoLoadTO tmpTO = queue[i];
            CacheAopProxyChain pjp = tmpTO.getJoinPoint();
            String className = pjp.getTarget().getClass().getName();
            String methodName = pjp.getMethod().getName();
            CacheKeyTO cacheKeyTO = tmpTO.getCacheKey();
            AutoLoadVO autoLoadVO = new AutoLoadVO();
            autoLoadVO.setNamespace(cacheKeyTO.getNamespace());
            autoLoadVO.setKey(cacheKeyTO.getKey());
            autoLoadVO.setHfield(cacheKeyTO.getHfield());
            autoLoadVO.setMethod(className + "." + methodName);
            autoLoadVO.setLastRequestTime(this.formatDate(tmpTO.getLastRequestTime()));
            autoLoadVO.setFirstRequestTime(this.formatDate(tmpTO.getFirstRequestTime()));
            autoLoadVO.setRequestTimes(tmpTO.getRequestTimes());
            autoLoadVO.setLastLoadTime(this.formatDate(tmpTO.getLastLoadTime()));
            autoLoadVO.setExpire(tmpTO.getCache().expire());
            autoLoadVO.setExpireTime(this.formatDate(tmpTO.getLastLoadTime() + (long)(tmpTO.getCache().expire() * 1000)));
            autoLoadVO.setRequestTimeout(tmpTO.getCache().requestTimeout());
            autoLoadVO.setRequestTimeoutTime(this.formatDate(tmpTO.getLastRequestTime() + tmpTO.getCache().requestTimeout() * 1000L));
            autoLoadVO.setLoadCount(tmpTO.getLoadCnt());
            autoLoadVO.setAverageUseTime(tmpTO.getAverageUseTime());
            autoLoadVOs[i] = autoLoadVO;
        }
        return autoLoadVOs;
    }

    @GetMapping(value={"/args"})
    public Object[] showArgs(String key, String hfield) {
        CacheKeyTO cacheKeyTO = new CacheKeyTO(this.autoloadCacheHandler.getAutoLoadConfig().getNamespace(), key, hfield);
        AutoLoadTO tmpTO = this.autoloadCacheHandler.getAutoLoadHandler().getAutoLoadTO(cacheKeyTO);
        if (null != tmpTO && null != tmpTO.getArgs()) {
            return tmpTO.getArgs();
        }
        return null;
    }

    @PostMapping(value={"removeCache"})
    public boolean removeCache(String key, String hfield) {
        CacheKeyTO cacheKeyTO = new CacheKeyTO(this.autoloadCacheHandler.getAutoLoadConfig().getNamespace(), key, hfield);
        try {
            this.autoloadCacheHandler.delete(cacheKeyTO);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @PostMapping(value={"removeAutoloadTO"})
    public boolean removeAutoloadTO(String key, String hfield) {
        CacheKeyTO cacheKeyTO = new CacheKeyTO(this.autoloadCacheHandler.getAutoLoadConfig().getNamespace(), key, hfield);
        try {
            this.autoloadCacheHandler.getAutoLoadHandler().removeAutoLoadTO(cacheKeyTO);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @PostMapping(value={"resetLastLoadTime"})
    public boolean resetLastLoadTime(String key, String hfield) {
        CacheKeyTO cacheKeyTO = new CacheKeyTO(this.autoloadCacheHandler.getAutoLoadConfig().getNamespace(), key, hfield);
        try {
            this.autoloadCacheHandler.getAutoLoadHandler().resetAutoLoadLastLoadTime(cacheKeyTO);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private String formatDate(long time) {
        if (time < 100000L) {
            return "";
        }
        Date date = new Date(time);
        return FORMATER.get().format(date);
    }
}

