/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.autoconfigure.AutoloadCacheManageConfiguration;
import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.lock.JedisClusterLock;
import com.jarvis.cache.redis.SpringJedisLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisCluster;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class, AutoloadCacheManageConfiguration.class})
public class DistributedLockConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLockConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={ILock.class})
    public ILock autoLoadCacheDistributedLock(RedisConnectionFactory connectionFactory) {
        if (null == connectionFactory) {
            return null;
        }
        if (!(connectionFactory instanceof JedisConnectionFactory)) {
            logger.debug("connectionFactory is not JedisConnectionFactory");
            return null;
        }
        RedisConnection redisConnection = null;
        try {
            redisConnection = connectionFactory.getConnection();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        if (null != redisConnection) {
            if (redisConnection instanceof RedisClusterConnection) {
                RedisClusterConnection redisClusterConnection = (RedisClusterConnection)redisConnection;
                JedisCluster jedisCluster = null;
                jedisCluster = (JedisCluster)redisClusterConnection.getNativeConnection();
                if (null != jedisCluster) {
                    JedisClusterLock lock = new JedisClusterLock(jedisCluster);
                    logger.debug("ILock with JedisClusterLock auto-configured");
                    return lock;
                }
            } else if (redisConnection instanceof JedisConnection) {
                SpringJedisLock lock = new SpringJedisLock((JedisConnectionFactory)connectionFactory);
                logger.debug("ILock with SpringJedisLock auto-configured");
                return lock;
            }
        }
        return null;
    }
}

