/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.StringSerializer;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class SpringJedisCacheManager
implements ICacheManager {
    private static final Logger logger = LoggerFactory.getLogger(SpringJedisCacheManager.class);
    private static final StringSerializer keySerializer = new StringSerializer();
    private final ISerializer<Object> serializer;
    private JedisConnectionFactory redisConnectionFactory;
    private int hashExpire = -1;
    private boolean hashExpireByScript = false;
    private static byte[] hashSetScript;
    private static final Map<Jedis, byte[]> hashSetScriptSha;
    private static byte[] delScript;
    private static final Map<Jedis, byte[]> delScriptSha;

    public SpringJedisCacheManager(ISerializer<Object> serializer) {
        this.serializer = serializer;
    }

    public JedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    public void setRedisConnectionFactory(JedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(CacheKeyTO cacheKeyTO, CacheWrapper<Object> result, Method method, Object[] args) throws CacheCenterConnectionException {
        if (null == this.redisConnectionFactory || null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return;
        }
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            int expire = result.getExpire();
            String hfield = cacheKeyTO.getHfield();
            if (null == hfield || hfield.length() == 0) {
                if (expire == 0) {
                    jedis.set(keySerializer.serialize(cacheKey), this.serializer.serialize(result));
                } else if (expire > 0) {
                    jedis.setex(keySerializer.serialize(cacheKey), expire, this.serializer.serialize(result));
                }
            } else {
                this.hashSet(jedis, cacheKey, hfield, result);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }

    private void hashSet(Jedis jedis, String cacheKey, String hfield, CacheWrapper<Object> result) throws Exception {
        byte[] key = keySerializer.serialize(cacheKey);
        byte[] field = keySerializer.serialize(hfield);
        byte[] val = this.serializer.serialize(result);
        int hExpire = this.hashExpire < 0 ? result.getExpire() : this.hashExpire;
        if (hExpire == 0) {
            jedis.hset(key, field, val);
        } else if (hExpire > 0) {
            if (this.hashExpireByScript) {
                byte[] sha = hashSetScriptSha.get(jedis);
                if (null == sha) {
                    sha = jedis.scriptLoad(hashSetScript);
                    hashSetScriptSha.put(jedis, sha);
                }
                ArrayList<byte[]> keys = new ArrayList<byte[]>();
                keys.add(key);
                keys.add(field);
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(val);
                args.add(keySerializer.serialize(String.valueOf(hExpire)));
                try {
                    jedis.evalsha(sha, keys, args);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    try {
                        sha = jedis.scriptLoad(hashSetScript);
                        hashSetScriptSha.put(jedis, sha);
                        jedis.evalsha(sha, keys, args);
                    }
                    catch (Exception ex1) {
                        logger.error(ex1.getMessage(), (Throwable)ex1);
                    }
                }
            } else {
                Pipeline p = jedis.pipelined();
                p.hset(key, field, val);
                p.expire(key, hExpire);
                p.sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheWrapper<Object> get(CacheKeyTO cacheKeyTO, Method method, Object[] args) throws CacheCenterConnectionException {
        if (null == this.redisConnectionFactory || null == cacheKeyTO) {
            return null;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return null;
        }
        CacheWrapper res = null;
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            byte[] bytes = null;
            String hfield = cacheKeyTO.getHfield();
            bytes = null == hfield || hfield.length() == 0 ? jedis.get(keySerializer.serialize(cacheKey)) : jedis.hget(keySerializer.serialize(cacheKey), keySerializer.serialize(hfield));
            Type returnType = method.getGenericReturnType();
            res = (CacheWrapper)this.serializer.deserialize(bytes, returnType);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CacheKeyTO cacheKeyTO) throws CacheCenterConnectionException {
        if (null == this.redisConnectionFactory || null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.length() == 0) {
            return;
        }
        logger.debug("delete cache:" + cacheKey);
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            if ("*".equals(cacheKey)) {
                jedis.flushDB();
            } else if (cacheKey.indexOf("*") != -1) {
                this.batchDel(jedis, cacheKey);
            } else {
                String hfield = cacheKeyTO.getHfield();
                if (null == hfield || hfield.length() == 0) {
                    jedis.del(keySerializer.serialize(cacheKey));
                } else {
                    jedis.hdel(keySerializer.serialize(cacheKey), (byte[][])new byte[][]{keySerializer.serialize(hfield)});
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void batchDel(Jedis jedis, String cacheKey) throws Exception {
        byte[] sha = delScriptSha.get(jedis);
        byte[] key = keySerializer.serialize(cacheKey);
        if (null == sha) {
            sha = jedis.scriptLoad(delScript);
            delScriptSha.put(jedis, sha);
        }
        try {
            List keys = (List)jedis.evalsha(sha, 1, (byte[][])new byte[][]{key});
            if (null != keys && keys.size() <= 0) return;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            try {
                sha = jedis.scriptLoad(delScript);
                delScriptSha.put(jedis, sha);
                List keys = (List)jedis.evalsha(sha, 1, (byte[][])new byte[][]{key});
                if (null != keys && keys.size() <= 0) return;
            }
            catch (Exception ex1) {
                logger.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
    }

    public int getHashExpire() {
        return this.hashExpire;
    }

    public void setHashExpire(int hashExpire) {
        if (hashExpire < 0) {
            return;
        }
        this.hashExpire = hashExpire;
    }

    public boolean isHashExpireByScript() {
        return this.hashExpireByScript;
    }

    public void setHashExpireByScript(boolean hashExpireByScript) {
        this.hashExpireByScript = hashExpireByScript;
    }

    static {
        try {
            String tmpScript = "redis.call('HSET', KEYS[1], KEYS[2], ARGV[1]);\nredis.call('EXPIRE', KEYS[1], tonumber(ARGV[2]));";
            hashSetScript = tmpScript.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        hashSetScriptSha = new ConcurrentHashMap<Jedis, byte[]>();
        StringBuilder tmp = new StringBuilder();
        tmp.append("local keys = redis.call('keys', KEYS[1]);\n");
        tmp.append("if(not keys or #keys == 0) then \n return nil; \n end \n");
        tmp.append("redis.call('del', unpack(keys)); \n return keys;");
        try {
            delScript = tmp.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        delScriptSha = new ConcurrentHashMap<Jedis, byte[]>();
    }
}

