/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.lock.AbstractRedisLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import redis.clients.jedis.Jedis;

public class SpringJedisLock
extends AbstractRedisLock {
    private static final Logger logger = LoggerFactory.getLogger(SpringJedisLock.class);
    private final JedisConnectionFactory redisConnectionFactory;

    public SpringJedisLock(JedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long setnx(String key, String val) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return -1L;
        }
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            Long l = jedis.setnx(key, val);
            return l;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expire(String key, int expire) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0 || expire < 0) {
            return;
        }
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            jedis.expire(key, expire);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String get(String key) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return null;
        }
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSet(String key, String newVal) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return null;
        }
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            String string = jedis.getSet(key, newVal);
            return string;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void del(String key) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return;
        }
        RedisConnection redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            jedis.del(key);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }

    public JedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }
}

