/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.admin;

import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import java.io.IOException;
import java.util.Base64;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class HTTPBasicAuthorizeAttribute
implements Filter {
    private static final String SESSION_AUTH_ATTRIBUTE = "autoload-cache-auth";
    private final AutoloadCacheProperties properties;

    public HTTPBasicAuthorizeAttribute(AutoloadCacheProperties properties) {
        this.properties = properties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String sessionAuth = (String)request.getSession().getAttribute(SESSION_AUTH_ATTRIBUTE);
        if (sessionAuth == null && !this.checkHeaderAuth(request, response)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
            response.setHeader("WWW-Authenticate", "Basic realm=\"input username and password\"");
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean checkHeaderAuth(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] userArray;
        String decodedAuth;
        String userName = this.properties.getAdminUserName();
        if (null == userName || userName.isEmpty()) {
            return true;
        }
        String password = this.properties.getAdminPassword();
        String auth = request.getHeader("Authorization");
        if (auth != null && auth.length() > 6 && (decodedAuth = this.getFromBASE64(auth = auth.substring(6, auth.length()))) != null && (userArray = decodedAuth.split(":")) != null && userArray.length == 2 && userName.equals(userArray[0]) && (null == password || password.isEmpty() || null != password && password.equals(userArray[1]))) {
            request.getSession().setAttribute(SESSION_AUTH_ATTRIBUTE, (Object)decodedAuth);
            return true;
        }
        return false;
    }

    private String getFromBASE64(String s) {
        if (s == null) {
            return null;
        }
        try {
            byte[] b = Base64.getDecoder().decode(s);
            return new String(b);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void destroy() {
    }
}

