/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.lock.AbstractRedisLock;
import com.jarvis.cache.serializer.StringSerializer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.types.Expiration;

public class SpringRedisLock
extends AbstractRedisLock {
    private static final Logger logger = LoggerFactory.getLogger(SpringRedisLock.class);
    private static final StringSerializer STRING_SERIALIZER = new StringSerializer();
    private final RedisConnectionFactory redisConnectionFactory;

    public SpringRedisLock(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    private RedisConnection getConnection() {
        return RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setnx(String key, String val, int expire) {
        if (null == this.redisConnectionFactory || null == key || key.isEmpty()) {
            return false;
        }
        RedisConnection redisConnection = this.getConnection();
        try {
            Expiration expiration = Expiration.from((long)expire, (TimeUnit)TimeUnit.SECONDS);
            boolean bl = redisConnection.stringCommands().set(STRING_SERIALIZER.serialize(key), STRING_SERIALIZER.serialize(val), expiration, RedisStringCommands.SetOption.SET_IF_ABSENT);
            return bl;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void del(String key) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return;
        }
        RedisConnection redisConnection = this.getConnection();
        try {
            redisConnection.keyCommands().del((byte[][])new byte[][]{STRING_SERIALIZER.serialize(key)});
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory);
        }
    }
}

