/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils;

import com.tuyang.beanutils.BeanCopier;
import com.tuyang.beanutils.internal.cache.BeanCopyCache;
import com.tuyang.beanutils.internal.dump.BeanCopyDump;
import com.tuyang.beanutils.internal.utils.InstanceUtils;
import com.tuyang.beanutils.internal.utils.PropertyUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;

public class BeanCopyUtils {
    public static BeanCopier getBeanCopier(Class<?> sourceClass, Class<?> targetClass) {
        return BeanCopyUtils.getBeanCopier(sourceClass, targetClass, null);
    }

    public static BeanCopier getBeanCopier(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass must not be null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass must not be null");
        }
        return BeanCopyCache.getBeanCopy(sourceClass, targetClass, optionClass);
    }

    public static <T> T copyBean(Object sourceObject, Class<T> targetClass) {
        return (T)BeanCopyUtils.copyBean(sourceObject, targetClass, null);
    }

    public static Object copyBean(Object sourceObject, Object targetObject) {
        return BeanCopyUtils.copyBean(sourceObject, targetObject, null);
    }

    public static <T> T copyBean(Object sourceObject, Class<T> targetClass, Class<?> optionClass) {
        if (sourceObject == null) {
            return null;
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass must not be null");
        }
        T targetObject = InstanceUtils.newInstance(targetClass);
        return BeanCopyUtils.copyBean(sourceObject, targetObject, optionClass);
    }

    public static <T> T copyBean(Object sourceObject, T targetObject, Class<?> optionClass) {
        if (sourceObject == null) {
            throw new NullPointerException("sourceObject must not be null");
        }
        if (targetObject == null) {
            throw new NullPointerException("targetObject must not be null");
        }
        BeanCopyDump.beginDump();
        BeanCopier beanCopy = BeanCopyCache.getBeanCopy(sourceObject.getClass(), targetObject.getClass(), optionClass);
        targetObject = beanCopy.copyBean(sourceObject, targetObject);
        BeanCopyDump.endDump();
        return targetObject;
    }

    public static <S, T> List<T> copyList(List<S> sourceList, Class<T> targetClass) {
        return (List)BeanCopyUtils.copyCollection(sourceList, targetClass, null);
    }

    public static <S, T> List<T> copyList(List<S> sourceList, Class<T> targetClass, Class<?> optionClass) {
        return (List)BeanCopyUtils.copyCollection(sourceList, targetClass, optionClass);
    }

    public static <S, T> List<T> copyList(S[] sourceArray, Class<T> targetClass) {
        return BeanCopyUtils.copyList(sourceArray, targetClass, null);
    }

    public static <S, T> List<T> copyList(S[] sourceArray, Class<T> targetClass, Class<?> optionClass) {
        if (sourceArray == null) {
            return null;
        }
        BeanCopyDump.beginDump();
        List dataList = (List)InstanceUtils.newCollection(List.class);
        for (S s : sourceArray) {
            Class<T> newInst = BeanCopyUtils.copyBean(s, targetClass, optionClass);
            dataList.add(newInst);
        }
        BeanCopyDump.endDump();
        return dataList;
    }

    public static <S, T> T[] copyArray(List<S> sourceList, Class<T> targetClass) {
        return BeanCopyUtils.copyArray(sourceList, targetClass, null);
    }

    public static <S, T> T[] copyArray(List<S> sourceList, Class<T> targetClass, Class<?> optionClass) {
        if (sourceList == null) {
            return null;
        }
        BeanCopyDump.beginDump();
        Object[] tArray = (Object[])Array.newInstance(targetClass, sourceList.size());
        int index = 0;
        if (PropertyUtils.isPrimitive(targetClass)) {
            for (S s : sourceList) {
                Array.set(tArray, index++, s);
            }
        } else {
            for (S s : sourceList) {
                Class<T> newInst = BeanCopyUtils.copyBean(s, targetClass, optionClass);
                tArray[index++] = newInst;
            }
        }
        BeanCopyDump.endDump();
        return tArray;
    }

    public static <S, T> T[] copyArray(S[] sourceArray, Class<T> targetClass) {
        return BeanCopyUtils.copyArray(sourceArray, targetClass, null);
    }

    public static <S, T> T[] copyArray(S[] sourceArray, Class<T> targetClass, Class<?> optionClass) {
        if (sourceArray == null) {
            return null;
        }
        BeanCopyDump.beginDump();
        Object[] tArray = (Object[])Array.newInstance(targetClass, sourceArray.length);
        int index = 0;
        if (PropertyUtils.isPrimitive(targetClass)) {
            for (S s : sourceArray) {
                Array.set(tArray, index++, s);
            }
        } else {
            for (S s : sourceArray) {
                Class<T> newInst = BeanCopyUtils.copyBean(s, targetClass, optionClass);
                tArray[index++] = newInst;
            }
        }
        BeanCopyDump.endDump();
        return tArray;
    }

    public static <S, T> Collection<T> copyCollection(Collection<S> sourceCollection, Class<T> targetClass) {
        return BeanCopyUtils.copyCollection(sourceCollection, targetClass, null);
    }

    public static <S, T> Collection<T> copyCollection(Collection<S> sourceCollection, Class<T> targetClass, Class<?> optionClass) {
        if (sourceCollection == null) {
            return null;
        }
        BeanCopyDump.beginDump();
        Collection dataList = InstanceUtils.newCollection(sourceCollection.getClass());
        for (S s : sourceCollection) {
            Class<T> newInst = BeanCopyUtils.copyBean(s, targetClass, optionClass);
            dataList.add(newInst);
        }
        BeanCopyDump.endDump();
        return dataList;
    }

    public static void dumpPropertyMapping(Object sourceObject, Object targetObject) {
        BeanCopyDump.dumpPropertyMapping(sourceObject.getClass(), targetObject.getClass(), targetObject.getClass());
    }

    public static void dumpPropertyMapping(Object sourceObject, Object targetObject, Class<?> optionClass) {
        BeanCopyDump.dumpPropertyMapping(sourceObject.getClass(), targetObject.getClass(), optionClass);
    }

    public static void dumpPropertyMapping(Object sourceObject, Class<?> targetClass) {
        BeanCopyDump.dumpPropertyMapping(sourceObject.getClass(), targetClass, targetClass);
    }

    public static void dumpPropertyMapping(Object sourceObject, Class<?> targetClass, Class<?> optionClass) {
        BeanCopyDump.dumpPropertyMapping(sourceObject.getClass(), targetClass, optionClass);
    }

    public static void dumpPropertyMapping(Class<?> sourceClass, Class<?> targetClass) {
        BeanCopyDump.dumpPropertyMapping(sourceClass, targetClass, targetClass);
    }

    public static void dumpPropertyMapping(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass) {
        BeanCopyDump.dumpPropertyMapping(sourceClass, targetClass, optionClass);
    }
}

