/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.config;

import com.tuyang.beanutils.internal.cache.BeanCopyCache;
import com.tuyang.beanutils.internal.factory.BeanCopierFactory;
import com.tuyang.beanutils.internal.javassist.JavassistBeanCopyFactory;
import com.tuyang.beanutils.internal.logger.Logger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;

public class BeanCopyConfig {
    private static BeanCopyConfig INSTANCE = new BeanCopyConfig();
    private int logLevel = Logger.LogLevelWarn;
    private Class<?> setClass = HashSet.class;
    private Class<?> listClass = ArrayList.class;
    private Class<?> queueClass = ArrayDeque.class;
    private Class<?> dequeClass = ArrayDeque.class;
    private Class<? extends BeanCopierFactory> beanCopyFactory = JavassistBeanCopyFactory.class;
    private DumpOption dumpOption = DumpOption.AutoDumpAtFirstCopy;
    private ClassLoader classLoader = null;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static BeanCopyConfig instance() {
        return INSTANCE;
    }

    public static void setBeanCopyConfig(BeanCopyConfig beanCopyConfig) {
        if (beanCopyConfig == null) {
            beanCopyConfig = new BeanCopyConfig();
        }
        INSTANCE = beanCopyConfig;
        BeanCopyCache.setBeanCopyConfig(beanCopyConfig);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public Class<?> getSetClass() {
        return this.setClass;
    }

    public void setSetClass(Class<?> setClass) {
        this.setClass = setClass;
    }

    public Class<?> getListClass() {
        return this.listClass;
    }

    public void setListClass(Class<?> listClass) {
        this.listClass = listClass;
    }

    public Class<? extends BeanCopierFactory> getBeanCopyFactory() {
        return this.beanCopyFactory;
    }

    public void setBeanCopyFactory(Class<? extends BeanCopierFactory> beanCopyFactory) {
        this.beanCopyFactory = beanCopyFactory;
    }

    public Class<?> getQueueClass() {
        return this.queueClass;
    }

    public void setQueueClass(Class<?> queueClass) {
        this.queueClass = queueClass;
    }

    public Class<?> getDequeClass() {
        return this.dequeClass;
    }

    public void setDequeClass(Class<?> dequeClass) {
        this.dequeClass = dequeClass;
    }

    public DumpOption getDumpOption() {
        return this.dumpOption;
    }

    public void setDumpOption(DumpOption dumpOption) {
        this.dumpOption = dumpOption;
    }

    public static enum DumpOption {
        AutoDumpNone,
        AutoDumpAtFirstCopy,
        AutoDumpAlways;

    }
}

