/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.cache;

import com.tuyang.beanutils.BeanCopier;
import com.tuyang.beanutils.BeanCopyConvertor;
import com.tuyang.beanutils.annotation.BeanCopySource;
import com.tuyang.beanutils.annotation.CopyCollection;
import com.tuyang.beanutils.annotation.CopyFeature;
import com.tuyang.beanutils.annotation.CopyProperty;
import com.tuyang.beanutils.config.BeanCopyConfig;
import com.tuyang.beanutils.exception.BeanCopyException;
import com.tuyang.beanutils.internal.cache.BeanCopyPropertyItem;
import com.tuyang.beanutils.internal.convertors.ArrayConvertorFactory;
import com.tuyang.beanutils.internal.convertors.EnumToEnumArrayConvertor;
import com.tuyang.beanutils.internal.convertors.EnumToStringArrayConvertor;
import com.tuyang.beanutils.internal.convertors.EnumToStringConvertor;
import com.tuyang.beanutils.internal.convertors.ListToEnumArrayConvertor;
import com.tuyang.beanutils.internal.convertors.ObjectToEnumConvertor;
import com.tuyang.beanutils.internal.convertors.ObjectToStringArrayConvertor;
import com.tuyang.beanutils.internal.convertors.ObjectToStringConvertor;
import com.tuyang.beanutils.internal.convertors.StringToEnumArrayConvertor;
import com.tuyang.beanutils.internal.dump.BeanCopyDump;
import com.tuyang.beanutils.internal.factory.BeanCopierFactory;
import com.tuyang.beanutils.internal.logger.Logger;
import com.tuyang.beanutils.internal.utils.PropertyUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanCopyCache {
    private static Logger logger = Logger.getLogger(BeanCopyCache.class);
    private static Map<Long, SoftReference<BeanCopier>> beanCopyCacheMap = new ConcurrentHashMap<Long, SoftReference<BeanCopier>>();
    private static BeanCopyConfig beanCopyConfig = BeanCopyConfig.instance();
    private static BeanCopierFactory beanCopyFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBeanCopyConfig(BeanCopyConfig beanCopyConfig) {
        if (beanCopyConfig == null) {
            beanCopyConfig = new BeanCopyConfig();
        }
        BeanCopyCache.beanCopyConfig = beanCopyConfig;
        Class<BeanCopyCache> clazz = BeanCopyCache.class;
        synchronized (BeanCopyCache.class) {
            if (beanCopyFactory != null && !beanCopyFactory.equals(beanCopyConfig.getBeanCopyFactory())) {
                beanCopyCacheMap.clear();
            }
            beanCopyFactory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanCopier getBeanCopy(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass) {
        long cacheKey = ((long)sourceClass.hashCode() << 16) + (long)targetClass.hashCode();
        cacheKey = optionClass != null ? (cacheKey << 16) + (long)optionClass.hashCode() : (cacheKey << 16) + (long)targetClass.hashCode();
        BeanCopier beanCopy = null;
        SoftReference<BeanCopier> refBeanCopy = beanCopyCacheMap.get(cacheKey);
        if (refBeanCopy != null) {
            beanCopy = refBeanCopy.get();
        }
        if (BeanCopyConfig.instance().getDumpOption() == BeanCopyConfig.DumpOption.AutoDumpAlways) {
            BeanCopyDump.dumpPropertyMapping(sourceClass, targetClass, optionClass);
        }
        if (beanCopy != null) {
            return beanCopy;
        }
        Class<BeanCopyCache> clazz = BeanCopyCache.class;
        synchronized (BeanCopyCache.class) {
            if (beanCopyFactory == null) {
                try {
                    beanCopyFactory = beanCopyConfig.getBeanCopyFactory().newInstance();
                }
                catch (Exception e) {
                    throw new BeanCopyException("BeanCopyConfig is not configured correctly!");
                }
            }
            if ((refBeanCopy = beanCopyCacheMap.get(cacheKey)) != null) {
                beanCopy = refBeanCopy.get();
            }
            if (beanCopy != null) {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return beanCopy;
            }
            CopyFeature[] features = BeanCopyCache.parseBeanCopyFeatures(sourceClass, targetClass, optionClass);
            List<BeanCopyPropertyItem> itemList = BeanCopyCache.buildBeanCopyPropertyItem(sourceClass, targetClass, optionClass);
            beanCopy = beanCopyFactory.createBeanCopier(sourceClass, targetClass, itemList, features);
            if (beanCopy != null) {
                beanCopyCacheMap.put(cacheKey, new SoftReference<BeanCopier>(beanCopy));
            }
            if (BeanCopyConfig.instance().getDumpOption() == BeanCopyConfig.DumpOption.AutoDumpAtFirstCopy) {
                BeanCopyDump.dumpPropertyMapping(sourceClass, targetClass, optionClass, itemList);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return beanCopy;
        }
    }

    private static CopyFeature[] parseBeanCopyFeatures(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass) {
        Class<?> sourceClassFromAnnotation;
        BeanCopySource source;
        if (optionClass != null && optionClass.isAnnotationPresent(BeanCopySource.class)) {
            source = optionClass.getAnnotation(BeanCopySource.class);
            sourceClassFromAnnotation = source.source();
            if (sourceClassFromAnnotation.isAssignableFrom(sourceClass)) {
                return source.features();
            }
            if (sourceClass.getName().startsWith(sourceClassFromAnnotation.getName())) {
                return source.features();
            }
        }
        if (targetClass.isAnnotationPresent(BeanCopySource.class) && (sourceClassFromAnnotation = (source = targetClass.getAnnotation(BeanCopySource.class)).source()).isAssignableFrom(sourceClass)) {
            return source.features();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BeanCopyPropertyItem> buildBeanCopyPropertyItem(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass) {
        PropertyDescriptor[] targetPds;
        Class<?> sourceClassFromAnnotation;
        ArrayList<BeanCopyPropertyItem> itemList = new ArrayList<BeanCopyPropertyItem>();
        Class<?> beanAnnotationSource = null;
        BeanCopySource beanCopySource = null;
        if (optionClass != null && optionClass.isAnnotationPresent(BeanCopySource.class)) {
            beanCopySource = optionClass.getAnnotation(BeanCopySource.class);
            sourceClassFromAnnotation = beanCopySource.source();
            if (sourceClassFromAnnotation.isAssignableFrom(sourceClass)) {
                beanAnnotationSource = sourceClassFromAnnotation;
            } else if (sourceClass.getName().startsWith(sourceClassFromAnnotation.getName())) {
                beanAnnotationSource = sourceClassFromAnnotation;
            }
        }
        if (beanAnnotationSource == null && targetClass.isAnnotationPresent(BeanCopySource.class)) {
            beanCopySource = targetClass.getAnnotation(BeanCopySource.class);
            sourceClassFromAnnotation = beanCopySource.source();
            if (sourceClassFromAnnotation.isAssignableFrom(sourceClass)) {
                beanAnnotationSource = sourceClassFromAnnotation;
            } else if (sourceClass.getName().startsWith(sourceClassFromAnnotation.getName())) {
                beanAnnotationSource = sourceClassFromAnnotation;
            }
        }
        boolean enumThrowExceptions = true;
        boolean useObjectToStringCopy = false;
        CopyFeature[] features = null;
        if (beanCopySource != null) {
            for (CopyFeature feature : features = beanCopySource.features()) {
                if (feature == CopyFeature.IGNORE_ENUM_CONVERT_EXCEPTION) {
                    enumThrowExceptions = false;
                    continue;
                }
                if (feature != CopyFeature.ENABLE_JAVA_BEAN_TO_STRING) continue;
                useObjectToStringCopy = true;
            }
        }
        PropertyDescriptor[] propertyDescriptorArray = targetPds = PropertyUtils.getPropertyDescriptors(targetClass);
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (true) {
            block74: {
                BeanCopyPropertyItem item;
                PropertyDescriptor sourcePd;
                String[] propertyNames;
                Annotation copyAnnotation;
                Class<?> collectionClass;
                Class<?> propertyOptionClass;
                boolean isCollection;
                boolean sourceIsArray;
                Class<?> methodSourceArray;
                Class<?> methodSourceType;
                Method[] readMethods;
                Class<?> methodTargetType;
                String propertyName;
                Method writeMethod;
                block78: {
                    PropertyDescriptor targetPd;
                    block92: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        block87: {
                                            block86: {
                                                boolean targetIsArray;
                                                Class<?> methodTargetArray;
                                                block80: {
                                                    block85: {
                                                        block84: {
                                                            block83: {
                                                                BeanCopyPropertyItem item2;
                                                                block82: {
                                                                    block81: {
                                                                        block79: {
                                                                            Object convertorObject;
                                                                            Class<?> convertorClass;
                                                                            block76: {
                                                                                BeanCopySource source;
                                                                                BeanCopyPropertyItem item3;
                                                                                Method readMethod;
                                                                                block77: {
                                                                                    String annotationPropertyName;
                                                                                    Field propertyField;
                                                                                    block75: {
                                                                                        if (n2 >= n) {
                                                                                            return itemList;
                                                                                        }
                                                                                        targetPd = propertyDescriptorArray[n2];
                                                                                        writeMethod = null;
                                                                                        writeMethod = targetPd.getWriteMethod();
                                                                                        if (writeMethod == null) break block74;
                                                                                        propertyName = null;
                                                                                        propertyField = null;
                                                                                        methodTargetType = null;
                                                                                        methodTargetArray = null;
                                                                                        targetIsArray = false;
                                                                                        readMethods = null;
                                                                                        methodSourceType = null;
                                                                                        methodSourceArray = null;
                                                                                        sourceIsArray = false;
                                                                                        convertorClass = null;
                                                                                        convertorObject = null;
                                                                                        isCollection = false;
                                                                                        propertyOptionClass = null;
                                                                                        collectionClass = null;
                                                                                        propertyName = targetPd.getName();
                                                                                        propertyField = null;
                                                                                        methodTargetArray = methodTargetType = writeMethod.getParameterTypes()[0];
                                                                                        targetIsArray = methodTargetType.isArray();
                                                                                        if (targetIsArray) {
                                                                                            methodTargetType = methodTargetArray.getComponentType();
                                                                                        }
                                                                                        if ((propertyField = PropertyUtils.getClassField(targetClass, optionClass, propertyName)) == null || !propertyField.isAnnotationPresent(CopyProperty.class)) break block75;
                                                                                        copyAnnotation = propertyField.getAnnotation(CopyProperty.class);
                                                                                        annotationPropertyName = copyAnnotation.property();
                                                                                        if (copyAnnotation.ignored()) break block74;
                                                                                        if (annotationPropertyName != null && !"".equals(annotationPropertyName)) {
                                                                                            if (beanAnnotationSource == null) {
                                                                                                logger.warn("BeanCopy: " + targetClass.getName() + " has no BeanCopySource annotation, but " + propertyName + " has BeanProperty annotation with property defined");
                                                                                                throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " has no BeanCopySource annotation, but " + propertyName + " has BeanProperty annotation with property defined");
                                                                                            }
                                                                                            propertyName = annotationPropertyName;
                                                                                        }
                                                                                        propertyNames = null;
                                                                                        propertyNames = propertyName.contains(".") ? propertyName.split("\\.") : new String[]{propertyName};
                                                                                        readMethods = new Method[propertyNames.length];
                                                                                        methodSourceType = sourceClass;
                                                                                        break block76;
                                                                                    }
                                                                                    if (propertyField == null || !propertyField.isAnnotationPresent(CopyCollection.class)) break block77;
                                                                                    copyAnnotation = propertyField.getAnnotation(CopyCollection.class);
                                                                                    annotationPropertyName = copyAnnotation.property();
                                                                                    if (copyAnnotation.ignored()) break block74;
                                                                                    if (annotationPropertyName != null && !"".equals(annotationPropertyName)) {
                                                                                        if (beanAnnotationSource == null) {
                                                                                            logger.warn("BeanCopy: " + targetClass.getName() + " has no BeanCopySource annotation, but " + propertyName + " has BeanProperty annotation with property defined");
                                                                                            throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " has no BeanCopySource annotation, but " + propertyName + " has BeanProperty annotation with property defined");
                                                                                        }
                                                                                        propertyName = annotationPropertyName;
                                                                                    }
                                                                                    propertyNames = null;
                                                                                    propertyNames = propertyName.contains(".") ? propertyName.split("\\.") : new String[]{propertyName};
                                                                                    readMethods = new Method[propertyNames.length];
                                                                                    methodSourceType = sourceClass;
                                                                                    break block78;
                                                                                }
                                                                                PropertyDescriptor sourcePd2 = PropertyUtils.getPropertyDescriptor(sourceClass, propertyName);
                                                                                if (sourcePd2 == null || (readMethod = sourcePd2.getReadMethod()) == null) break block74;
                                                                                methodSourceType = readMethod.getReturnType();
                                                                                methodSourceArray = methodSourceType;
                                                                                sourceIsArray = methodSourceArray.isArray();
                                                                                if (sourceIsArray) {
                                                                                    methodSourceType = methodSourceArray.getComponentType();
                                                                                }
                                                                                readMethods = new Method[]{readMethod};
                                                                                if (targetIsArray && !sourceIsArray || !targetIsArray && sourceIsArray) {
                                                                                    logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Array type mismatch!!");
                                                                                    throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Array type mismatch!!");
                                                                                }
                                                                                if (!targetIsArray) {
                                                                                    if (PropertyUtils.isAssignable(methodTargetType, methodSourceType)) {
                                                                                        item3 = new BeanCopyPropertyItem();
                                                                                        item3.propertyName = propertyName;
                                                                                        item3.writeMethod = writeMethod;
                                                                                        item3.readMethods = readMethods;
                                                                                        item3.isCollection = false;
                                                                                        item3.useBeanCopy = false;
                                                                                        itemList.add(item3);
                                                                                    } else {
                                                                                        if (!methodTargetType.isAnnotationPresent(BeanCopySource.class)) {
                                                                                            logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                            throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                        }
                                                                                        source = methodTargetType.getAnnotation(BeanCopySource.class);
                                                                                        Class<?> sourceClassFromAnnotation2 = source.source();
                                                                                        if (!sourceClassFromAnnotation2.equals(methodSourceType)) {
                                                                                            logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                            throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                        }
                                                                                        item2 = new BeanCopyPropertyItem();
                                                                                        item2.propertyName = propertyName;
                                                                                        item2.writeMethod = writeMethod;
                                                                                        item2.readMethods = readMethods;
                                                                                        item2.isCollection = false;
                                                                                        item2.useBeanCopy = false;
                                                                                        item2.optionClass = methodTargetType;
                                                                                        itemList.add(item2);
                                                                                    }
                                                                                }
                                                                                if (!targetIsArray) break block74;
                                                                                if (methodSourceArray.equals(methodTargetArray)) {
                                                                                    item3 = new BeanCopyPropertyItem();
                                                                                    item3.propertyName = propertyName;
                                                                                    item3.writeMethod = writeMethod;
                                                                                    item3.readMethods = readMethods;
                                                                                    item3.isCollection = false;
                                                                                    item3.useBeanCopy = false;
                                                                                    itemList.add(item3);
                                                                                    break block74;
                                                                                } else if (PropertyUtils.isAssignable(methodTargetType, methodSourceType)) {
                                                                                    item3 = new BeanCopyPropertyItem();
                                                                                    item3.propertyName = propertyName;
                                                                                    item3.writeMethod = writeMethod;
                                                                                    item3.readMethods = readMethods;
                                                                                    item3.isCollection = false;
                                                                                    item3.useBeanCopy = false;
                                                                                    item3.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, null);
                                                                                    item3.convertorClass = item3.convertorObject.getClass();
                                                                                    itemList.add(item3);
                                                                                    break block74;
                                                                                } else {
                                                                                    if (!methodTargetType.isAnnotationPresent(BeanCopySource.class)) {
                                                                                        logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                        throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                    }
                                                                                    source = methodTargetType.getAnnotation(BeanCopySource.class);
                                                                                    Class<?> sourceClassFromAnnotation3 = source.source();
                                                                                    if (!sourceClassFromAnnotation3.equals(methodSourceType)) {
                                                                                        logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                        throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                                    }
                                                                                    item2 = new BeanCopyPropertyItem();
                                                                                    item2.propertyName = propertyName;
                                                                                    item2.writeMethod = writeMethod;
                                                                                    item2.readMethods = readMethods;
                                                                                    item2.isCollection = false;
                                                                                    item2.useBeanCopy = false;
                                                                                    item2.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, methodTargetType);
                                                                                    item2.convertorClass = item2.convertorObject.getClass();
                                                                                    itemList.add(item2);
                                                                                }
                                                                                break block74;
                                                                            }
                                                                            for (int i = 0; i < propertyNames.length; ++i) {
                                                                                sourcePd = PropertyUtils.getPropertyDescriptor(methodSourceType, propertyNames[i]);
                                                                                if (sourcePd == null) {
                                                                                    logger.error("BeanCopy: " + methodSourceType.getName() + " has no property " + propertyNames[i] + " defined.!");
                                                                                    throw new BeanCopyException("BeanCopy: " + methodSourceType.getName() + " has no property " + propertyNames[i] + " defined.!");
                                                                                }
                                                                                readMethods[i] = sourcePd.getReadMethod();
                                                                                methodSourceType = readMethods[i].getReturnType();
                                                                            }
                                                                            methodSourceArray = methodSourceType;
                                                                            sourceIsArray = methodSourceArray.isArray();
                                                                            if (sourceIsArray) {
                                                                                methodSourceType = methodSourceArray.getComponentType();
                                                                            }
                                                                            convertorClass = copyAnnotation.convertor();
                                                                            convertorObject = null;
                                                                            if (convertorClass.equals(Void.TYPE)) {
                                                                                convertorClass = null;
                                                                            } else {
                                                                                if (!PropertyUtils.isInterfaceType(convertorClass, BeanCopyConvertor.class)) {
                                                                                    convertorClass = null;
                                                                                    logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor property is not a convertor class!!");
                                                                                    throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor property is not a convertor class!!");
                                                                                }
                                                                                if (convertorClass.isInterface()) {
                                                                                    logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor is a interface!!");
                                                                                    throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor is a interface!!");
                                                                                }
                                                                                try {
                                                                                    Type[] genericInterfaces = convertorClass.getGenericInterfaces();
                                                                                    ParameterizedType convertorInterface = null;
                                                                                    for (Type type : genericInterfaces) {
                                                                                        ParameterizedType parameterizedType = (ParameterizedType)type;
                                                                                        if (!parameterizedType.getRawType().equals(BeanCopyConvertor.class)) continue;
                                                                                        convertorInterface = parameterizedType;
                                                                                    }
                                                                                    Class converterClassSource = null;
                                                                                    Class converterClassTarget = null;
                                                                                    Type[] converterTypes = convertorInterface.getActualTypeArguments();
                                                                                    converterClassSource = converterTypes[0] instanceof ParameterizedType ? (Class)((ParameterizedType)converterTypes[0]).getRawType() : (Class)converterTypes[0];
                                                                                    converterClassTarget = converterTypes[1] instanceof ParameterizedType ? (Class)((ParameterizedType)converterTypes[1]).getRawType() : (Class)converterTypes[1];
                                                                                    if (!PropertyUtils.isAssignable(methodSourceType, converterClassSource) || !PropertyUtils.isAssignable(methodTargetType, converterClassTarget)) {
                                                                                        logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor does match the type!!");
                                                                                        throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor does match the type!!");
                                                                                    }
                                                                                }
                                                                                catch (Exception e) {
                                                                                    logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor: get generic type error!!", e);
                                                                                    throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor: get generic type error!!", e);
                                                                                }
                                                                            }
                                                                            propertyOptionClass = copyAnnotation.optionClass();
                                                                            if (propertyOptionClass.equals(Void.TYPE) || propertyOptionClass.equals(Void.class)) {
                                                                                propertyOptionClass = null;
                                                                            }
                                                                            if (convertorClass != null && propertyOptionClass != null) {
                                                                                logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor and optionClass cannot be set both!!");
                                                                                throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor and optionClass cannot be set both!!");
                                                                            }
                                                                            if (convertorClass == null && (!targetIsArray && sourceIsArray || targetIsArray && !sourceIsArray && !PropertyUtils.isInterfaceType(methodSourceType, Collection.class))) {
                                                                                logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Array type mismatch!!");
                                                                                throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Array type mismatch!!");
                                                                            }
                                                                            if ((PropertyUtils.isPrimitive(methodSourceType) || PropertyUtils.isPrimitive(methodTargetType)) && propertyOptionClass != null) {
                                                                                logger.error("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty optionClass cannot be set on primitive tpye!!");
                                                                                throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " Annotation BeanProperty convertor and optionClass on primitive tpye!!");
                                                                            }
                                                                            if (convertorClass == null) break block79;
                                                                            BeanCopyPropertyItem item4 = new BeanCopyPropertyItem();
                                                                            item4.propertyName = propertyName;
                                                                            item4.writeMethod = writeMethod;
                                                                            item4.readMethods = readMethods;
                                                                            item4.isCollection = isCollection;
                                                                            item4.useBeanCopy = false;
                                                                            item4.optionClass = null;
                                                                            item4.convertorClass = convertorClass;
                                                                            item4.convertorObject = convertorObject;
                                                                            itemList.add(item4);
                                                                            break block74;
                                                                        }
                                                                        if (targetIsArray) break block80;
                                                                        if (!PropertyUtils.isAssignable(methodTargetType, methodSourceType)) break block81;
                                                                        if (PropertyUtils.isPrimitive(methodTargetType) || methodTargetType.isEnum()) {
                                                                            BeanCopyPropertyItem item5 = new BeanCopyPropertyItem();
                                                                            item5.propertyName = propertyName;
                                                                            item5.writeMethod = writeMethod;
                                                                            item5.readMethods = readMethods;
                                                                            item5.isCollection = false;
                                                                            item5.optionClass = null;
                                                                            item5.convertorClass = null;
                                                                            item5.useBeanCopy = false;
                                                                            itemList.add(item5);
                                                                            break block74;
                                                                        } else {
                                                                            BeanCopyPropertyItem item6 = new BeanCopyPropertyItem();
                                                                            item6.propertyName = propertyName;
                                                                            item6.writeMethod = writeMethod;
                                                                            item6.readMethods = readMethods;
                                                                            item6.isCollection = false;
                                                                            item6.optionClass = null;
                                                                            item6.convertorClass = null;
                                                                            item6.useBeanCopy = true;
                                                                            itemList.add(item6);
                                                                        }
                                                                        break block74;
                                                                    }
                                                                    if (propertyOptionClass == null) break block82;
                                                                    BeanCopyPropertyItem item7 = new BeanCopyPropertyItem();
                                                                    item7.propertyName = propertyName;
                                                                    item7.writeMethod = writeMethod;
                                                                    item7.readMethods = readMethods;
                                                                    item7.isCollection = false;
                                                                    item7.useBeanCopy = false;
                                                                    item7.optionClass = propertyOptionClass;
                                                                    itemList.add(item7);
                                                                    break block74;
                                                                }
                                                                if (!methodTargetType.isAnnotationPresent(BeanCopySource.class)) break block83;
                                                                beanCopySource = methodTargetType.getAnnotation(BeanCopySource.class);
                                                                Class<?> sourceClassFromAnnotation4 = beanCopySource.source();
                                                                if (!sourceClassFromAnnotation4.equals(methodSourceType)) {
                                                                    logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                    throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                                }
                                                                item2 = new BeanCopyPropertyItem();
                                                                item2.propertyName = propertyName;
                                                                item2.writeMethod = writeMethod;
                                                                item2.readMethods = readMethods;
                                                                item2.isCollection = false;
                                                                item2.useBeanCopy = false;
                                                                item2.optionClass = methodTargetType;
                                                                itemList.add(item2);
                                                                break block74;
                                                            }
                                                            if (!methodTargetType.isEnum()) break block84;
                                                            BeanCopyPropertyItem item8 = new BeanCopyPropertyItem();
                                                            item8.propertyName = propertyName;
                                                            item8.writeMethod = writeMethod;
                                                            item8.readMethods = readMethods;
                                                            item8.isCollection = false;
                                                            item8.optionClass = null;
                                                            item8.convertorClass = ObjectToEnumConvertor.class;
                                                            item8.convertorObject = new ObjectToEnumConvertor(methodTargetType, enumThrowExceptions);
                                                            item8.useBeanCopy = true;
                                                            itemList.add(item8);
                                                            break block74;
                                                        }
                                                        if (!methodTargetType.equals(String.class) || !methodSourceType.isEnum()) break block85;
                                                        BeanCopyPropertyItem item9 = new BeanCopyPropertyItem();
                                                        item9.propertyName = propertyName;
                                                        item9.writeMethod = writeMethod;
                                                        item9.readMethods = readMethods;
                                                        item9.isCollection = false;
                                                        item9.optionClass = null;
                                                        item9.convertorClass = EnumToStringConvertor.class;
                                                        item9.convertorObject = new EnumToStringConvertor();
                                                        item9.useBeanCopy = true;
                                                        itemList.add(item9);
                                                        break block74;
                                                    }
                                                    if (!PropertyUtils.isPrimitive(methodSourceType) && !PropertyUtils.isPrimitive(methodTargetType)) {
                                                        BeanCopyPropertyItem item10 = new BeanCopyPropertyItem();
                                                        item10.propertyName = propertyName;
                                                        item10.writeMethod = writeMethod;
                                                        item10.readMethods = readMethods;
                                                        item10.isCollection = false;
                                                        item10.optionClass = null;
                                                        item10.convertorClass = null;
                                                        item10.useBeanCopy = true;
                                                        itemList.add(item10);
                                                        break block74;
                                                    } else if (useObjectToStringCopy && methodTargetType.equals(String.class)) {
                                                        BeanCopyPropertyItem item11 = new BeanCopyPropertyItem();
                                                        item11.propertyName = propertyName;
                                                        item11.writeMethod = writeMethod;
                                                        item11.readMethods = readMethods;
                                                        item11.isCollection = false;
                                                        item11.optionClass = null;
                                                        item11.convertorClass = ObjectToStringConvertor.class;
                                                        item11.convertorObject = new ObjectToStringConvertor();
                                                        item11.useBeanCopy = false;
                                                        itemList.add(item11);
                                                        break block74;
                                                    } else {
                                                        logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                        throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                                    }
                                                }
                                                if (!targetIsArray) break block74;
                                                if (!methodTargetArray.equals(methodSourceArray)) break block86;
                                                if (methodSourceType.isEnum()) {
                                                    BeanCopyPropertyItem item12 = new BeanCopyPropertyItem();
                                                    item12.propertyName = propertyName;
                                                    item12.writeMethod = writeMethod;
                                                    item12.readMethods = readMethods;
                                                    item12.isCollection = false;
                                                    item12.useBeanCopy = false;
                                                    item12.optionClass = null;
                                                    item12.convertorObject = new EnumToEnumArrayConvertor();
                                                    item12.convertorClass = item12.convertorObject.getClass();
                                                    itemList.add(item12);
                                                    break block74;
                                                } else {
                                                    BeanCopyPropertyItem item13 = new BeanCopyPropertyItem();
                                                    item13.propertyName = propertyName;
                                                    item13.writeMethod = writeMethod;
                                                    item13.readMethods = readMethods;
                                                    item13.isCollection = false;
                                                    item13.useBeanCopy = false;
                                                    item13.optionClass = null;
                                                    item13.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, null);
                                                    item13.convertorClass = item13.convertorObject.getClass();
                                                    itemList.add(item13);
                                                }
                                                break block74;
                                            }
                                            if (!PropertyUtils.isAssignable(methodTargetType, methodSourceType)) break block87;
                                            BeanCopyPropertyItem item14 = new BeanCopyPropertyItem();
                                            item14.propertyName = propertyName;
                                            item14.writeMethod = writeMethod;
                                            item14.readMethods = readMethods;
                                            item14.isCollection = false;
                                            item14.useBeanCopy = false;
                                            item14.optionClass = null;
                                            item14.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, null);
                                            item14.convertorClass = item14.convertorObject.getClass();
                                            itemList.add(item14);
                                            break block74;
                                        }
                                        if (!PropertyUtils.isInterfaceType(methodSourceType, Collection.class)) break block88;
                                        if (methodTargetType.isEnum()) {
                                            BeanCopyPropertyItem item15 = new BeanCopyPropertyItem();
                                            item15.propertyName = propertyName;
                                            item15.writeMethod = writeMethod;
                                            item15.readMethods = readMethods;
                                            item15.isCollection = false;
                                            item15.useBeanCopy = false;
                                            item15.optionClass = null;
                                            item15.convertorObject = new ListToEnumArrayConvertor(methodTargetType, enumThrowExceptions);
                                            item15.convertorClass = item15.convertorObject.getClass();
                                            itemList.add(item15);
                                            break block74;
                                        } else {
                                            BeanCopyPropertyItem item16 = new BeanCopyPropertyItem();
                                            item16.propertyName = propertyName;
                                            item16.writeMethod = writeMethod;
                                            item16.readMethods = readMethods;
                                            item16.isCollection = true;
                                            item16.useBeanCopy = true;
                                            item16.convertorObject = null;
                                            item16.convertorClass = null;
                                            item16.optionClass = propertyOptionClass;
                                            item16.features = features;
                                            itemList.add(item16);
                                        }
                                        break block74;
                                    }
                                    if (propertyOptionClass == null) break block89;
                                    BeanCopyPropertyItem item17 = new BeanCopyPropertyItem();
                                    item17.propertyName = propertyName;
                                    item17.writeMethod = writeMethod;
                                    item17.readMethods = readMethods;
                                    item17.isCollection = false;
                                    item17.useBeanCopy = false;
                                    item17.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, propertyOptionClass);
                                    item17.convertorClass = item17.convertorObject.getClass();
                                    item17.optionClass = null;
                                    itemList.add(item17);
                                    break block74;
                                }
                                if (!methodTargetType.isAnnotationPresent(BeanCopySource.class)) break block90;
                                BeanCopySource source = methodTargetType.getAnnotation(BeanCopySource.class);
                                Class<?> sourceClassFromAnnotation5 = source.source();
                                if (!sourceClassFromAnnotation5.equals(methodSourceType)) {
                                    logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                    throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                                }
                                BeanCopyPropertyItem item18 = new BeanCopyPropertyItem();
                                item18.propertyName = propertyName;
                                item18.writeMethod = writeMethod;
                                item18.readMethods = readMethods;
                                item18.isCollection = false;
                                item18.useBeanCopy = false;
                                item18.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, methodTargetType);
                                item18.convertorClass = item18.convertorObject.getClass();
                                item18.optionClass = null;
                                itemList.add(item18);
                                break block74;
                            }
                            if (!methodSourceType.isEnum() || !methodTargetType.equals(String.class)) break block91;
                            BeanCopyPropertyItem item19 = new BeanCopyPropertyItem();
                            item19.propertyName = propertyName;
                            item19.writeMethod = writeMethod;
                            item19.readMethods = readMethods;
                            item19.isCollection = false;
                            item19.optionClass = null;
                            item19.convertorClass = EnumToStringArrayConvertor.class;
                            item19.convertorObject = new EnumToStringArrayConvertor();
                            item19.useBeanCopy = true;
                            itemList.add(item19);
                            break block74;
                        }
                        if (!methodSourceType.equals(String.class) || !methodTargetType.isEnum()) break block92;
                        BeanCopyPropertyItem item20 = new BeanCopyPropertyItem();
                        item20.propertyName = propertyName;
                        item20.writeMethod = writeMethod;
                        item20.readMethods = readMethods;
                        item20.isCollection = false;
                        item20.optionClass = null;
                        item20.convertorClass = StringToEnumArrayConvertor.class;
                        item20.convertorObject = new StringToEnumArrayConvertor(methodTargetType, enumThrowExceptions);
                        item20.useBeanCopy = true;
                        itemList.add(item20);
                        break block74;
                    }
                    if (!PropertyUtils.isPrimitive(methodSourceType) && !PropertyUtils.isPrimitive(methodTargetType)) {
                        BeanCopyPropertyItem item21 = new BeanCopyPropertyItem();
                        item21.propertyName = propertyName;
                        item21.writeMethod = writeMethod;
                        item21.readMethods = readMethods;
                        item21.isCollection = false;
                        item21.optionClass = null;
                        item21.convertorClass = null;
                        item21.useBeanCopy = false;
                        item21.convertorObject = ArrayConvertorFactory.getArrayConvertor(methodSourceType, methodTargetType, null);
                        item21.convertorClass = item21.convertorObject.getClass();
                        item21.optionClass = null;
                        itemList.add(item21);
                        break block74;
                    } else if (useObjectToStringCopy && methodTargetType.equals(String.class)) {
                        BeanCopyPropertyItem item22 = new BeanCopyPropertyItem();
                        item22.propertyName = propertyName;
                        item22.writeMethod = writeMethod;
                        item22.readMethods = readMethods;
                        item22.isCollection = false;
                        item22.optionClass = null;
                        item22.convertorClass = ObjectToStringArrayConvertor.class;
                        item22.convertorObject = new ObjectToStringArrayConvertor();
                        item22.useBeanCopy = false;
                        itemList.add(item22);
                        break block74;
                    } else {
                        logger.warn("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                        throw new BeanCopyException("Property parameter does not match: " + sourceClass.getName() + "[" + propertyName + "(" + methodSourceType.getSimpleName() + ")] : " + targetClass.getName() + "[" + targetPd.getName() + "(" + methodTargetType.getSimpleName() + ")]");
                    }
                }
                for (int i = 0; i < propertyNames.length; ++i) {
                    sourcePd = PropertyUtils.getPropertyDescriptor(methodSourceType, propertyNames[i]);
                    if (sourcePd == null) {
                        logger.error("BeanCopy: " + methodSourceType.getName() + " has no property " + propertyNames[i] + " defined.!");
                        throw new BeanCopyException("BeanCopy: " + methodSourceType.getName() + " has no property " + propertyNames[i] + " defined.!");
                    }
                    readMethods[i] = sourcePd.getReadMethod();
                    methodSourceType = readMethods[i].getReturnType();
                }
                methodSourceArray = methodSourceType;
                sourceIsArray = methodSourceArray.isArray();
                if (sourceIsArray) {
                    methodSourceType = methodSourceArray.getComponentType();
                }
                if ((propertyOptionClass = copyAnnotation.optionClass()).equals(Void.TYPE) || propertyOptionClass.equals(Void.class)) {
                    propertyOptionClass = null;
                }
                if (!PropertyUtils.isInterfaceType(methodSourceArray, Collection.class) && !methodSourceArray.isArray()) {
                    logger.warn("BeanCopy: " + sourceClass.getName() + " property " + propertyName + " is not collection type!");
                    throw new BeanCopyException("BeanCopy: " + sourceClass.getName() + " property " + propertyName + " is not collection type!");
                }
                if (!PropertyUtils.isInterfaceType(methodTargetType, Collection.class)) {
                    logger.warn("BeanCopy: " + targetClass.getName() + " property " + propertyName + " is not collection type!");
                    throw new BeanCopyException("BeanCopy: " + targetClass.getName() + " property " + propertyName + " is not collection type!");
                }
                isCollection = true;
                collectionClass = copyAnnotation.targetClass();
                if (methodSourceArray.isArray()) {
                    item = new BeanCopyPropertyItem();
                    item.propertyName = propertyName;
                    item.writeMethod = writeMethod;
                    item.readMethods = readMethods;
                    item.isCollection = true;
                    item.useBeanCopy = true;
                    item.collectionClass = collectionClass;
                    item.optionClass = propertyOptionClass;
                    itemList.add(item);
                } else if (collectionClass.isEnum()) {
                    item = new BeanCopyPropertyItem();
                    item.propertyName = propertyName;
                    item.writeMethod = writeMethod;
                    item.readMethods = readMethods;
                    item.isCollection = true;
                    item.useBeanCopy = true;
                    item.collectionClass = collectionClass;
                    item.optionClass = propertyOptionClass;
                    itemList.add(item);
                } else if (collectionClass.equals(String.class) && useObjectToStringCopy) {
                    item = new BeanCopyPropertyItem();
                    item.propertyName = propertyName;
                    item.writeMethod = writeMethod;
                    item.readMethods = readMethods;
                    item.isCollection = true;
                    item.useBeanCopy = true;
                    item.collectionClass = collectionClass;
                    item.optionClass = propertyOptionClass;
                    itemList.add(item);
                } else {
                    item = new BeanCopyPropertyItem();
                    item.propertyName = propertyName;
                    item.writeMethod = writeMethod;
                    item.readMethods = readMethods;
                    item.isCollection = true;
                    item.useBeanCopy = false;
                    item.collectionClass = collectionClass;
                    item.optionClass = propertyOptionClass;
                    itemList.add(item);
                }
            }
            ++n2;
        }
    }
}

