/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.convertors;

import com.tuyang.beanutils.BeanCopyConvertor;
import java.lang.reflect.Array;
import java.util.Collection;

public class ListToEnumArrayConvertor
implements BeanCopyConvertor<Collection<Object>, Object[]> {
    private Class enumClass;
    private boolean throwExceptions;

    public ListToEnumArrayConvertor(Class enumClass, boolean throwExceptions) {
        this.enumClass = enumClass;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public Object[] convertTo(Collection<Object> objects) {
        if (objects == null) {
            return null;
        }
        Object[] retList = (Object[])Array.newInstance(this.enumClass, objects.size());
        if (this.throwExceptions) {
            int i = 0;
            for (Object object : objects) {
                if (object != null) {
                    String str = object.toString();
                    retList[i] = Enum.valueOf(this.enumClass, str);
                }
                ++i;
            }
            return retList;
        }
        Enum[] enums = (Enum[])this.enumClass.getEnumConstants();
        int i = 0;
        for (Object object : objects) {
            if (object != null) {
                String str = object.toString();
                for (Enum enumKey : enums) {
                    if (!enumKey.name().equals(str)) continue;
                    retList[i] = enumKey;
                }
            }
            ++i;
        }
        return retList;
    }
}

