/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.convertors;

import com.tuyang.beanutils.BeanCopyConvertor;
import com.tuyang.beanutils.BeanCopyUtils;
import java.lang.reflect.Array;

public class ObjectArrayConvertor
implements BeanCopyConvertor {
    private Class<?> methodTargetType;
    private Class<?> methodSourceType;
    private Class<?> propertyOptionClass;

    public ObjectArrayConvertor(Class<?> methodSourceType, Class<?> methodTargetType, Class<?> propertyOptionClass) {
        this.methodSourceType = methodSourceType;
        this.methodTargetType = methodTargetType;
        this.propertyOptionClass = propertyOptionClass;
    }

    public Object convertTo(Object object) {
        if (!object.getClass().isArray()) {
            return null;
        }
        if (!this.methodSourceType.equals(object.getClass().getComponentType())) {
            return null;
        }
        int length = Array.getLength(object);
        Object[] retObject = (Object[])Array.newInstance(this.methodTargetType, length);
        for (int i = 0; i < length; ++i) {
            retObject[i] = BeanCopyUtils.copyBean(Array.get(object, i), this.methodTargetType, this.propertyOptionClass);
        }
        return retObject;
    }
}

