/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.convertors;

import com.tuyang.beanutils.BeanCopyConvertor;

public class ObjectToEnumConvertor
implements BeanCopyConvertor<Object, Enum> {
    private Class enumClass;
    private boolean throwExceptions;

    public ObjectToEnumConvertor(Class enumClass, boolean throwExceptions) {
        this.enumClass = enumClass;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public Enum convertTo(Object object) {
        Enum[] enums;
        if (object == null) {
            return null;
        }
        if (this.throwExceptions) {
            return Enum.valueOf(this.enumClass, object.toString());
        }
        for (Enum enumKey : enums = (Enum[])this.enumClass.getEnumConstants()) {
            if (!enumKey.name().equals(object.toString())) continue;
            return enumKey;
        }
        return null;
    }
}

