/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.convertors;

import com.tuyang.beanutils.BeanCopyConvertor;
import java.lang.reflect.Array;

public class StringToEnumArrayConvertor
implements BeanCopyConvertor<String[], Object[]> {
    private Class enumClass;
    private boolean throwExceptions;

    public StringToEnumArrayConvertor(Class enumClass, boolean throwExceptions) {
        this.enumClass = enumClass;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public Object[] convertTo(String[] object) {
        if (object == null) {
            return null;
        }
        Object[] retList = (Object[])Array.newInstance(this.enumClass, object.length);
        if (this.throwExceptions) {
            for (int i = 0; i < object.length; ++i) {
                retList[i] = Enum.valueOf(this.enumClass, object[i]);
            }
            return retList;
        }
        Enum[] enums = (Enum[])this.enumClass.getEnumConstants();
        for (int i = 0; i < object.length; ++i) {
            for (Enum enumKey : enums) {
                if (!enumKey.name().equals(object[i])) continue;
                retList[i] = enumKey;
            }
        }
        return retList;
    }
}

