/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.dump;

import com.tuyang.beanutils.annotation.BeanCopySource;
import com.tuyang.beanutils.annotation.CopyFeature;
import com.tuyang.beanutils.config.BeanCopyConfig;
import com.tuyang.beanutils.internal.cache.BeanCopyCache;
import com.tuyang.beanutils.internal.cache.BeanCopyPropertyItem;
import com.tuyang.beanutils.internal.logger.Logger;
import com.tuyang.beanutils.internal.utils.PropertyUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BeanCopyDump {
    private static Logger logger = Logger.getLogger(BeanCopyDump.class);
    private static final int LineCharCount = 93;
    private static ThreadLocal<Integer> localDumpLevel = new ThreadLocal();
    private static ThreadLocal<List<Long>> localDumpStack = new ThreadLocal();

    public static void beginDump() {
        if (BeanCopyConfig.instance().getDumpOption() == BeanCopyConfig.DumpOption.AutoDumpNone) {
            return;
        }
        Integer dumpLevel = localDumpLevel.get();
        if (dumpLevel == null) {
            dumpLevel = -1;
        }
        if (dumpLevel == -1) {
            localDumpStack.set(new ArrayList());
        }
        dumpLevel = dumpLevel + 1;
        localDumpLevel.set(dumpLevel);
    }

    public static void endDump() {
        if (BeanCopyConfig.instance().getDumpOption() == BeanCopyConfig.DumpOption.AutoDumpNone) {
            return;
        }
        Integer dumpLevel = localDumpLevel.get();
        dumpLevel = dumpLevel - 1;
        localDumpLevel.set(dumpLevel);
        if (dumpLevel == -1 && localDumpStack.get().size() > 0) {
            logger.info("=============================================================================================");
        }
    }

    public static void dumpPropertyMapping(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass) {
        BeanCopyDump.dumpPropertyMapping(sourceClass, targetClass, optionClass, null);
    }

    public static void dumpPropertyMapping(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass, List<BeanCopyPropertyItem> itemList) {
        Integer dumpLevel;
        List<Long> stackCacheKeyList = localDumpStack.get();
        if (stackCacheKeyList == null) {
            stackCacheKeyList = new ArrayList<Long>();
            localDumpStack.set(stackCacheKeyList);
        }
        long cacheKey = ((long)sourceClass.hashCode() << 16) + (long)targetClass.hashCode();
        cacheKey = optionClass != null ? (cacheKey << 16) + (long)optionClass.hashCode() : (cacheKey << 16) + (long)targetClass.hashCode();
        if (stackCacheKeyList.contains(cacheKey)) {
            return;
        }
        if (stackCacheKeyList.isEmpty()) {
            logger.info("=============================================================================================");
            logger.info("Dump Bean Copy Property Mapping:");
        }
        if ((dumpLevel = localDumpLevel.get()) == null) {
            dumpLevel = -1;
        }
        if (dumpLevel == -1) {
            localDumpStack.set(new ArrayList());
        }
        dumpLevel = dumpLevel + 1;
        localDumpLevel.set(dumpLevel);
        BeanCopyDump.dumpPropertyMappingInternal(sourceClass, targetClass, optionClass, itemList);
        dumpLevel = dumpLevel - 1;
        localDumpLevel.set(dumpLevel);
        if (dumpLevel == -1 && localDumpStack.get().size() > 0) {
            logger.info("=============================================================================================");
        }
    }

    private static void dumpPropertyMappingInternal(Class<?> sourceClass, Class<?> targetClass, Class<?> optionClass, List<BeanCopyPropertyItem> itemList) {
        StringBuilder sBuilder;
        Class<?> belongClass;
        CopyFeature[] copyAnnotation;
        if (optionClass == null) {
            optionClass = targetClass;
        }
        List<Long> stackCacheKeyList = localDumpStack.get();
        long cacheKey = ((long)sourceClass.hashCode() << 16) + (long)targetClass.hashCode();
        cacheKey = optionClass != null ? (cacheKey << 16) + (long)optionClass.hashCode() : (cacheKey << 16) + (long)targetClass.hashCode();
        if (stackCacheKeyList.contains(cacheKey)) {
            return;
        }
        stackCacheKeyList.add(cacheKey);
        logger.info("---------------------------------------------------------------------------------------------");
        logger.info("From: [" + sourceClass.getSimpleName() + "] To: [" + targetClass.getSimpleName() + "] Option: [" + optionClass.getSimpleName() + "]");
        logger.info("---------------------------------------------------------------------------------------------");
        CopyFeature[] features = null;
        if (optionClass != null && optionClass.isAnnotationPresent(BeanCopySource.class)) {
            copyAnnotation = optionClass.getAnnotation(BeanCopySource.class);
            features = copyAnnotation.features();
        } else if (targetClass.isAnnotationPresent(BeanCopySource.class)) {
            copyAnnotation = targetClass.getAnnotation(BeanCopySource.class);
            features = copyAnnotation.features();
        }
        if (features == null || features.length == 0) {
            logger.info("CopyFeature: (NONE)");
        } else {
            logger.info("CopyFeature:");
            for (CopyFeature f : features) {
                logger.info("    " + f.toString());
            }
        }
        logger.info("---------------------------------------------------------------------------------------------");
        if (itemList == null) {
            itemList = BeanCopyCache.buildBeanCopyPropertyItem(sourceClass, targetClass, optionClass);
        }
        PropertyDescriptor[] sourcePds = PropertyUtils.getPropertyDescriptors(sourceClass);
        PropertyDescriptor[] targetPds = PropertyUtils.getPropertyDescriptors(targetClass);
        ArrayList<PropertyDescriptor> ignoredSourcePds = new ArrayList<PropertyDescriptor>();
        ArrayList<PropertyDescriptor> ignoredTargetPds = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pDescriptor : sourcePds) {
            ignoredSourcePds.add(pDescriptor);
        }
        for (PropertyDescriptor pDescriptor : targetPds) {
            ignoredTargetPds.add(pDescriptor);
        }
        for (BeanCopyPropertyItem item : itemList) {
            int i;
            Method readMethod = item.readMethods[0];
            Method writeMethod = item.writeMethod;
            PropertyDescriptor readPd = BeanCopyDump.findPropertyDescriptor(sourcePds, readMethod, true);
            PropertyDescriptor writePd = BeanCopyDump.findPropertyDescriptor(targetPds, writeMethod, false);
            ignoredSourcePds.remove(readPd);
            ignoredTargetPds.remove(writePd);
            if (readMethod.getDeclaringClass().equals(Object.class)) continue;
            Class<?> readType = item.readMethods[item.readMethods.length - 1].getReturnType();
            Class<?> writeType = writeMethod.getParameterTypes()[0];
            StringBuilder sBuilder2 = new StringBuilder();
            sBuilder2.append(readType.getSimpleName()).append(" ");
            for (i = 0; i < item.readMethods.length; ++i) {
                Method method = item.readMethods[i];
                if (i != 0) {
                    sBuilder2.append(".");
                }
                sBuilder2.append(method.getName()).append("()");
            }
            for (i = sBuilder2.length(); i < 46; ++i) {
                sBuilder2.insert(0, ' ');
            }
            sBuilder2.append("|");
            sBuilder2.append(writeType.getSimpleName()).append(" ");
            sBuilder2.append(item.writeMethod.getName()).append("()");
            logger.info(sBuilder2.toString());
        }
        if (!ignoredSourcePds.isEmpty()) {
            for (PropertyDescriptor pd : ignoredSourcePds) {
                Method method = pd.getReadMethod() != null ? pd.getReadMethod() : pd.getWriteMethod();
                belongClass = method.getDeclaringClass();
                if (belongClass.equals(Object.class)) continue;
                method = pd.getReadMethod();
                if (method != null) {
                    Class<?> readType = method.getReturnType();
                    StringBuilder sBuilder3 = new StringBuilder();
                    sBuilder3.append(readType.getSimpleName()).append(" ");
                    sBuilder3.append(method.getName()).append("()");
                    for (int i = sBuilder3.length(); i < 46; ++i) {
                        sBuilder3.insert(0, ' ');
                    }
                    sBuilder3.append("|(ignored)");
                    logger.info(sBuilder3.toString());
                    continue;
                }
                sBuilder = new StringBuilder();
                sBuilder.append("(No get method for ").append(pd.getName()).append(")");
                for (int i = sBuilder.length(); i < 46; ++i) {
                    sBuilder.insert(0, ' ');
                }
                sBuilder.append("|(ignored)");
                logger.info(sBuilder.toString());
            }
        }
        if (!ignoredTargetPds.isEmpty()) {
            for (PropertyDescriptor pd : ignoredTargetPds) {
                Method method = pd.getWriteMethod() != null ? pd.getWriteMethod() : pd.getReadMethod();
                belongClass = method.getDeclaringClass();
                if (belongClass.equals(Object.class)) continue;
                method = pd.getWriteMethod();
                if (method != null) {
                    Class<?> writeType = method.getParameterTypes()[0];
                    StringBuilder sBuilder4 = new StringBuilder();
                    sBuilder4.append("(ignored)");
                    for (int i = sBuilder4.length(); i < 46; ++i) {
                        sBuilder4.insert(0, ' ');
                    }
                    sBuilder4.append("|");
                    sBuilder4.append(writeType.getSimpleName()).append(" ");
                    sBuilder4.append(method.getName()).append("()");
                    logger.info(sBuilder4.toString());
                    continue;
                }
                sBuilder = new StringBuilder();
                sBuilder.append("(ignored)");
                for (int i = sBuilder.length(); i < 46; ++i) {
                    sBuilder.insert(0, ' ');
                }
                sBuilder.append("|");
                sBuilder.append("(No set method for " + pd.getName() + ")");
                logger.info(sBuilder.toString());
            }
        }
        for (BeanCopyPropertyItem item : itemList) {
            if (!item.useBeanCopy && item.optionClass == null) continue;
            Class<?> sourceProertyType = item.readMethods[item.readMethods.length - 1].getReturnType();
            Class<?> targetPropertyType = item.writeMethod.getParameterTypes()[0];
            if (targetPropertyType.isArray() || PropertyUtils.isInterfaceType(targetPropertyType, Collection.class) || sourceProertyType.isEnum() || targetPropertyType.isEnum()) continue;
            BeanCopyDump.dumpPropertyMappingInternal(sourceProertyType, targetPropertyType, item.optionClass, null);
        }
    }

    private static PropertyDescriptor findPropertyDescriptor(PropertyDescriptor[] sourcePds, Method method, boolean isRead) {
        for (PropertyDescriptor pDescriptor : sourcePds) {
            if (isRead && pDescriptor.getReadMethod() != null && pDescriptor.getReadMethod().equals(method)) {
                return pDescriptor;
            }
            if (isRead || pDescriptor.getWriteMethod() == null || !pDescriptor.getWriteMethod().equals(method)) continue;
            return pDescriptor;
        }
        return null;
    }
}

