/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.javassist;

import com.tuyang.beanutils.BeanCopier;
import com.tuyang.beanutils.BeanCopyConvertor;
import com.tuyang.beanutils.annotation.CopyFeature;
import com.tuyang.beanutils.config.BeanCopyConfig;
import com.tuyang.beanutils.internal.cache.BeanCopyPropertyItem;
import com.tuyang.beanutils.internal.factory.BeanCopierFactory;
import com.tuyang.beanutils.internal.logger.Logger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;

public class JavassistBeanCopyFactory
implements BeanCopierFactory {
    private static Logger logger = Logger.getLogger(JavassistBeanCopyFactory.class);
    private static int instanceCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanCopier createBeanCopier(Class<?> sourceClass, Class<?> targetClass, List<BeanCopyPropertyItem> items, CopyFeature[] features) {
        int thisCount = 0;
        JavassistBeanCopyFactory javassistBeanCopyFactory = this;
        synchronized (javassistBeanCopyFactory) {
            thisCount = instanceCount++;
        }
        String className = "com.tuyang.beanutils.internal.javassist.impl.BeanCopier$$javassist" + thisCount;
        if (sourceClass.getSimpleName().contains("$$") && sourceClass.getSuperclass() != null && sourceClass.getName().startsWith(sourceClass.getSuperclass().getName())) {
            sourceClass = sourceClass.getSuperclass();
        }
        try {
            int converterCount = 0;
            boolean hasFeature = false;
            ClassPool pool = ClassPool.getDefault();
            if (thisCount == 0) {
                ClassClassPath classPath = new ClassClassPath(this.getClass());
                pool.insertClassPath((ClassPath)classPath);
            }
            CtClass beanCopyInterface = pool.get(BeanCopier.class.getName());
            CtClass beanCopyCtClass = pool.makeClass(className);
            CtClass objectClass = pool.get(Object.class.getName());
            CtConstructor constructor = CtNewConstructor.defaultConstructor((CtClass)beanCopyCtClass);
            beanCopyCtClass.addConstructor(constructor);
            StringBuffer sb = new StringBuffer();
            sb.append("{\n");
            sb.append(sourceClass.getName() + " source = (" + sourceClass.getName() + ") $1;\n");
            sb.append(targetClass.getName() + " target = (" + targetClass.getName() + ") $2;\n");
            HashMap<String, BeanCopyConvertor> convertorMap = new HashMap<String, BeanCopyConvertor>();
            for (BeanCopyPropertyItem item : items) {
                CtMethod convertorMethod;
                String function;
                String methodName;
                CtField field;
                String convertorName;
                String sourceMethod = "";
                Class<?> writeType = item.writeMethod.getParameterTypes()[0];
                Class<?> readType = item.readMethods[item.readMethods.length - 1].getReturnType();
                if (item.readMethods.length == 1) {
                    sourceMethod = "source." + item.readMethods[0].getName() + "()";
                } else {
                    sourceMethod = "source";
                    sb.append("if( ");
                    for (int i = 0; i < item.readMethods.length - 1; ++i) {
                        if (i != 0) {
                            sb.append(" && ");
                        }
                        sourceMethod = sourceMethod + "." + item.readMethods[i].getName() + "()";
                        sb.append(sourceMethod + " != null ");
                    }
                    sb.append(" ) { \n");
                    sourceMethod = sourceMethod + "." + item.readMethods[item.readMethods.length - 1].getName() + "()";
                }
                if (!item.isCollection) {
                    boolean ignoreInvoke;
                    if (item.convertorObject != null) {
                        CtClass converterClass = pool.get(item.convertorClass.getName());
                        convertorName = "convertor" + converterCount++;
                        field = new CtField(converterClass, convertorName, beanCopyCtClass);
                        beanCopyCtClass.addField(field);
                        methodName = "set" + convertorName.substring(0, 1).toUpperCase() + convertorName.substring(1);
                        function = "this." + convertorName + "=$1;";
                        convertorMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)methodName, (CtClass[])new CtClass[]{converterClass}, null, (String)function, (CtClass)beanCopyCtClass);
                        beanCopyCtClass.addMethod(convertorMethod);
                        converterClass.detach();
                        convertorMap.put(methodName, item.convertorObject);
                        sb.append("target." + item.writeMethod.getName() + "((" + this.getClassName(writeType) + ")" + convertorName + ".convertTo(").append(sourceMethod + ") );\n");
                    } else if (item.convertorClass != null) {
                        CtClass converterClass = pool.get(item.convertorClass.getName());
                        convertorName = "convertor" + converterCount++;
                        field = new CtField(converterClass, convertorName, beanCopyCtClass);
                        beanCopyCtClass.addField(field);
                        constructor.insertAfter("this." + convertorName + " = (" + item.convertorClass.getName() + ") com.tuyang.beanutils.internal.utils.InstanceUtils.newInstance(" + item.convertorClass.getName() + ".class);");
                        sb.append("{\n");
                        sb.append(writeType.getName() + " local=" + convertorName + ".convertTo(");
                        if (readType.isPrimitive()) {
                            String objectPrimitiveName = this.getPrimitiveName(readType);
                            sb.append(objectPrimitiveName + ".valueOf( " + sourceMethod + "))");
                        } else {
                            sb.append(sourceMethod + ")");
                        }
                        if (writeType.isPrimitive()) {
                            sb.append("." + writeType.toString() + "Value()");
                        }
                        sb.append(";\n");
                        sb.append("target." + item.writeMethod.getName() + "( local );\n");
                        sb.append("}\n");
                        converterClass.detach();
                    } else if (item.optionClass != null) {
                        sb.append("target." + item.writeMethod.getName() + "( (" + writeType.getName() + ") com.tuyang.beanutils.BeanCopyUtils.copyBean( " + sourceMethod + ", " + writeType.getName() + ".class, " + item.optionClass.getName() + ".class ) );\n");
                    } else if (item.useBeanCopy) {
                        sb.append("target." + item.writeMethod.getName() + "( (" + writeType.getName() + ") com.tuyang.beanutils.BeanCopyUtils.copyBean( " + sourceMethod + ", " + writeType.getName() + ".class ) );\n");
                    } else if (writeType.isPrimitive() && !readType.isPrimitive()) {
                        ignoreInvoke = this.findFeature(features, CopyFeature.IGNORE_ALL_NULL_SOURCE_VALUE);
                        if (!ignoreInvoke) {
                            ignoreInvoke = this.findFeature(features, CopyFeature.IGNORE_PRIMITIVE_NULL_SOURCE_VALUE);
                        }
                        if (ignoreInvoke) {
                            sb.append("if ( " + sourceMethod + " != null ) { \n");
                        }
                        sb.append("target." + item.writeMethod.getName() + "( " + sourceMethod + "." + writeType.toString() + "Value() );\n");
                        if (ignoreInvoke) {
                            sb.append("}\n");
                        }
                    } else if (!writeType.isPrimitive() && readType.isPrimitive()) {
                        sb.append("target." + item.writeMethod.getName() + "( " + this.getPrimitiveName(readType) + ".valueOf(" + sourceMethod + " ) );\n");
                    } else if (!readType.isPrimitive()) {
                        ignoreInvoke = this.findFeature(features, CopyFeature.IGNORE_ALL_NULL_SOURCE_VALUE);
                        if (ignoreInvoke) {
                            sb.append("if ( " + sourceMethod + " != null ) { \n");
                        }
                        sb.append("target." + item.writeMethod.getName() + "( " + sourceMethod + " );\n");
                        if (ignoreInvoke) {
                            sb.append("}\n");
                        }
                    } else {
                        sb.append("target." + item.writeMethod.getName() + "( " + sourceMethod + " );\n");
                    }
                } else if (item.useBeanCopy) {
                    if (!hasFeature) {
                        hasFeature = true;
                        CtClass featureArrayClass = pool.get(CopyFeature.class.getName() + "[]");
                        convertorName = "features";
                        field = new CtField(featureArrayClass, convertorName, beanCopyCtClass);
                        beanCopyCtClass.addField(field);
                        methodName = "setFeatures";
                        function = "this.features=$1;";
                        convertorMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)methodName, (CtClass[])new CtClass[]{featureArrayClass}, null, (String)function, (CtClass)beanCopyCtClass);
                        beanCopyCtClass.addMethod(convertorMethod);
                        featureArrayClass.detach();
                    }
                    if (item.collectionClass != null) {
                        sb.append("target." + item.writeMethod.getName() + "( (" + writeType.getName() + ") com.tuyang.beanutils.internal.utils.InstanceUtils.unsafeCopyCollection( " + sourceMethod + ", " + item.collectionClass.getName() + ".class, " + (item.optionClass == null ? "null, " : item.optionClass.getName() + ".class, ") + writeType.getName() + ".class,  this.features ) );\n");
                    } else {
                        sb.append("target." + item.writeMethod.getName() + "( (" + writeType.getComponentType().getName() + "[] )com.tuyang.beanutils.internal.utils.InstanceUtils.unsafeCopyArray( " + sourceMethod + ", " + writeType.getComponentType().getName() + ".class, " + (item.optionClass == null ? "null " : item.optionClass.getName() + ".class ") + ", this.features ) );\n");
                    }
                } else {
                    sb.append("{ " + readType.getName() + " localList=" + sourceMethod + ";\n");
                    sb.append("if( localList !=null ) {\n");
                    sb.append(writeType.getName() + " targetList=(" + writeType.getName() + ")com.tuyang.beanutils.internal.utils.InstanceUtils.newCollection(" + writeType.getName() + ".class);\n");
                    sb.append("java.util.Iterator it = localList.iterator();\n");
                    sb.append("while( it.hasNext() ) {\n");
                    sb.append("targetList.add( com.tuyang.beanutils.BeanCopyUtils.copyBean( it.next(), " + item.collectionClass.getName() + ".class");
                    if (item.optionClass != null) {
                        sb.append(", " + item.optionClass.getName() + ".class");
                    }
                    sb.append("));\n}\n");
                    sb.append("target." + item.writeMethod.getName() + "( targetList );\n");
                    sb.append("} else { \ntarget." + item.writeMethod.getName() + "(null); }\n}\n");
                }
                if (item.readMethods.length <= 1) continue;
                sb.append("}\n");
            }
            sb.append("return target;}\n");
            CtMethod copyBeanMethod = CtNewMethod.make((CtClass)objectClass, (String)"copyBean", (CtClass[])new CtClass[]{objectClass, objectClass}, null, (String)sb.toString(), (CtClass)beanCopyCtClass);
            beanCopyCtClass.addMethod(copyBeanMethod);
            beanCopyCtClass.addInterface(beanCopyInterface);
            ClassLoader classLoader = BeanCopyConfig.instance().getClassLoader();
            if (classLoader == null) {
                classLoader = targetClass.getClassLoader();
            }
            Class classBeanCopy = beanCopyCtClass.toClass(classLoader, null);
            beanCopyCtClass.detach();
            BeanCopier retObject = (BeanCopier)classBeanCopy.newInstance();
            if (convertorMap.size() > 0) {
                for (String methodName : convertorMap.keySet()) {
                    BeanCopyConvertor convertor = (BeanCopyConvertor)convertorMap.get(methodName);
                    try {
                        Method method = retObject.getClass().getMethod(methodName, convertor.getClass());
                        method.invoke((Object)retObject, convertor);
                    }
                    catch (Exception exception) {}
                }
            }
            if (hasFeature) {
                try {
                    Method method = retObject.getClass().getMethod("setFeatures", features.getClass());
                    method.invoke((Object)retObject, new Object[]{features});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return retObject;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    private boolean findFeature(CopyFeature[] features, CopyFeature feature) {
        if (features == null || features.length == 0) {
            return false;
        }
        for (CopyFeature f : features) {
            if (f != feature) continue;
            return true;
        }
        return false;
    }

    private String getClassName(Class<?> writeType) {
        if (writeType.isArray()) {
            if (writeType.getComponentType().isPrimitive()) {
                if (writeType.equals(int[].class)) {
                    return "int[]";
                }
                if (writeType.equals(boolean[].class)) {
                    return "boolean[]";
                }
                if (writeType.equals(char[].class)) {
                    return "char[]";
                }
                if (writeType.equals(byte[].class)) {
                    return "byte[]";
                }
                if (writeType.equals(short[].class)) {
                    return "short[]";
                }
                if (writeType.equals(long[].class)) {
                    return "long[]";
                }
                if (writeType.equals(float[].class)) {
                    return "float[]";
                }
                if (writeType.equals(double[].class)) {
                    return "double[]";
                }
            } else {
                return writeType.getComponentType().getName() + "[]";
            }
        }
        return writeType.getName();
    }

    private String getPrimitiveName(Class<?> readType) {
        if (readType.equals(Integer.TYPE)) {
            return "Integer";
        }
        if (readType.equals(Float.TYPE)) {
            return "Float";
        }
        if (readType.equals(Boolean.TYPE)) {
            return "Boolean";
        }
        if (readType.equals(Character.TYPE)) {
            return "Character";
        }
        if (readType.equals(Byte.TYPE)) {
            return "Byte";
        }
        if (readType.equals(Long.TYPE)) {
            return "Long";
        }
        if (readType.equals(Short.TYPE)) {
            return "Short";
        }
        if (readType.equals(Double.TYPE)) {
            return "Double";
        }
        return "";
    }
}

