/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.logger;

import com.tuyang.beanutils.config.BeanCopyConfig;
import java.lang.reflect.Method;

public class Logger {
    public static int LogLevelAll = 0;
    public static int LogLevelTrace = 0;
    public static int LogLevelDebug = 1;
    public static int LogLevelInfo = 2;
    public static int LogLevelWarn = 3;
    public static int LogLevelError = 4;
    public static int LogLevelFatal = 5;
    public static int LogLevelNone = 6;
    Object logger = null;

    public static Logger getLogger(Class<?> clazz) {
        try {
            Class<?> loggerClass = Logger.class.getClassLoader().loadClass("org.apache.log4j.Logger");
            Method method = loggerClass.getMethod("getLogger", Class.class);
            Object logger = method.invoke(null, clazz);
            return new Logger(logger);
        }
        catch (Exception exception) {
            return new Logger(null);
        }
    }

    public Logger(Object logger) {
        this.logger = logger;
    }

    public void trace(Object message) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("trace", Object.class);
                method.invoke(this.logger, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelTrace) {
                return;
            }
            System.out.println(message.toString());
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("trace", Object.class, Throwable.class);
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelTrace) {
                return;
            }
            System.out.println(message.toString());
            t.printStackTrace();
        }
    }

    public void debug(Object message) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("debug", Object.class);
                method.invoke(this.logger, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelDebug) {
                return;
            }
            System.out.println(message.toString());
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("debug", Object.class, Throwable.class);
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelDebug) {
                return;
            }
            System.out.println(message.toString());
            t.printStackTrace();
        }
    }

    public void info(Object message) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("info", Object.class);
                method.invoke(this.logger, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelInfo) {
                return;
            }
            System.out.println(message.toString());
        }
    }

    public void info(Object message, Throwable t) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("info", Object.class, Throwable.class);
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelInfo) {
                return;
            }
            System.out.println(message.toString());
            t.printStackTrace();
        }
    }

    public void warn(Object message) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("warn", Object.class);
                method.invoke(this.logger, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelWarn) {
                return;
            }
            System.out.println(message.toString());
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("warn", Object.class, Throwable.class);
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelWarn) {
                return;
            }
            System.out.println(message.toString());
            t.printStackTrace();
        }
    }

    public void error(Object message) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("error", Object.class);
                method.invoke(this.logger, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelError) {
                return;
            }
            System.out.println(message.toString());
        }
    }

    public void error(Object message, Throwable t) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("error", Object.class, Throwable.class);
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() < LogLevelError) {
                return;
            }
            System.out.println(message.toString());
            t.printStackTrace();
        }
    }

    public void fatal(Object message) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("fatal", Object.class, Throwable.class);
                method.invoke(this.logger, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() > LogLevelDebug) {
                return;
            }
            System.out.println(message.toString());
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.logger != null) {
            try {
                Method method = this.logger.getClass().getMethod("fatal", Object.class, Throwable.class);
                method.invoke(this.logger, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (BeanCopyConfig.instance().getLogLevel() > LogLevelDebug) {
                return;
            }
            System.out.println(message.toString());
            t.printStackTrace();
        }
    }
}

