/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.reflect;

import com.tuyang.beanutils.BeanCopier;
import com.tuyang.beanutils.BeanCopyConvertor;
import com.tuyang.beanutils.BeanCopyUtils;
import com.tuyang.beanutils.annotation.CopyFeature;
import com.tuyang.beanutils.exception.BeanCopyException;
import com.tuyang.beanutils.internal.cache.BeanCopyPropertyItem;
import com.tuyang.beanutils.internal.logger.Logger;
import com.tuyang.beanutils.internal.utils.InstanceUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;

public class ReflectBeanCopy
implements BeanCopier {
    private static Logger logger = Logger.getLogger(BeanCopyUtils.class);
    private List<BeanCopyPropertyItem> items;
    private CopyFeature[] features;

    public ReflectBeanCopy(List<BeanCopyPropertyItem> items, CopyFeature[] features) {
        this.items = items;
        this.features = features;
    }

    @Override
    public Object copyBean(Object sourceObject, Object targetObject) {
        for (BeanCopyPropertyItem item : this.items) {
            Object targetValue;
            Class<?> targetPropertyType = item.writeMethod.getParameterTypes()[0];
            if (item.isCollection) {
                try {
                    targetValue = sourceObject;
                    for (int i = 0; i < item.readMethods.length; ++i) {
                        targetValue = item.readMethods[i].invoke(targetValue, new Object[0]);
                    }
                    if (item.useBeanCopy) {
                        Collection<?> writeObject = null;
                        writeObject = item.collectionClass != null ? InstanceUtils.unsafeCopyCollection(targetValue, item.collectionClass, item.optionClass, targetPropertyType, this.features) : InstanceUtils.unsafeCopyArray(targetValue, targetPropertyType.getComponentType(), item.optionClass, this.features);
                        item.writeMethod.invoke(targetObject, writeObject);
                        continue;
                    }
                    Collection collectionRead = (Collection)targetValue;
                    Collection collectionWrite = null;
                    if (collectionRead != null) {
                        collectionWrite = InstanceUtils.newCollection(targetPropertyType);
                        if (collectionWrite == null) {
                            logger.error("beanCopy: cannot copy collection property " + targetPropertyType.getSimpleName());
                            throw new BeanCopyException("beanCopy: cannot copy collection property " + targetPropertyType.getSimpleName());
                        }
                        for (Object sourceObj : collectionRead) {
                            Class<?> targetCollectionObject = BeanCopyUtils.copyBean(sourceObj, item.collectionClass, item.optionClass);
                            collectionWrite.add(targetCollectionObject);
                        }
                    }
                    item.writeMethod.invoke(targetObject, collectionWrite);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    logger.warn("beanCopy: cannot invoke property copy on " + item.writeMethod.getName(), e);
                    throw new BeanCopyException("beanCopy: cannot invoke property copy on " + item.writeMethod.getName(), e);
                }
            }
            try {
                targetValue = sourceObject;
                for (int i = 0; i < item.readMethods.length && targetValue != null; ++i) {
                    targetValue = item.readMethods[i].invoke(targetValue, new Object[0]);
                }
                Class<?> sourceData = targetValue;
                if (item.convertorObject != null) {
                    sourceData = item.convertorObject.convertTo(sourceData);
                } else if (item.convertorClass != null) {
                    BeanCopyConvertor convertor = (BeanCopyConvertor)InstanceUtils.newInstance(item.convertorClass);
                    sourceData = convertor.convertTo(sourceData);
                } else if (item.optionClass != null) {
                    if (sourceData != null) {
                        sourceData = BeanCopyUtils.copyBean((Object)sourceData, targetPropertyType, item.optionClass);
                    }
                } else if (item.useBeanCopy) {
                    sourceData = BeanCopyUtils.copyBean((Object)sourceData, targetPropertyType);
                }
                boolean ignoreInvoke = false;
                if (targetPropertyType.isPrimitive() && sourceData == null) {
                    ignoreInvoke = this.findFeature(CopyFeature.IGNORE_PRIMITIVE_NULL_SOURCE_VALUE);
                }
                if (!ignoreInvoke && sourceData == null) {
                    ignoreInvoke = this.findFeature(CopyFeature.IGNORE_ALL_NULL_SOURCE_VALUE);
                }
                if (ignoreInvoke) continue;
                item.writeMethod.invoke(targetObject, sourceData);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.warn("beanCopy: cannot invoke property copy on " + item.writeMethod.getName(), e);
                throw new BeanCopyException("beanCopy: cannot invoke property copy on " + item.writeMethod.getName(), e);
            }
        }
        return targetObject;
    }

    private boolean findFeature(CopyFeature feature) {
        if (this.features == null || this.features.length == 0) {
            return false;
        }
        for (CopyFeature f : this.features) {
            if (f != feature) continue;
            return true;
        }
        return false;
    }
}

