/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.utils;

import com.tuyang.beanutils.BeanCopyUtils;
import com.tuyang.beanutils.annotation.CopyFeature;
import com.tuyang.beanutils.config.BeanCopyConfig;
import com.tuyang.beanutils.exception.BeanCopyException;
import com.tuyang.beanutils.internal.dump.BeanCopyDump;
import com.tuyang.beanutils.internal.utils.PropertyUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class InstanceUtils {
    public static Collection newCollection(Class<?> clazz) {
        BeanCopyConfig config = BeanCopyConfig.instance();
        if (!PropertyUtils.isInterfaceType(clazz, Collection.class)) {
            throw new BeanCopyException("Invalid collection type for " + clazz.getSimpleName());
        }
        Class<?> paramClazz = clazz;
        while (clazz != null) {
            Class<?>[] interfaces;
            if (clazz.isInterface()) {
                if (clazz.equals(List.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getListClass());
                }
                if (clazz.equals(Set.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getSetClass());
                }
                if (clazz.equals(Deque.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getDequeClass());
                }
                if (clazz.equals(Queue.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getQueueClass());
                }
            }
            for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
                if (interfaceClass.equals(List.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getListClass());
                }
                if (interfaceClass.equals(Set.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getSetClass());
                }
                if (clazz.equals(Deque.class)) {
                    return (Collection)InstanceUtils.newInstance(config.getDequeClass());
                }
                if (!clazz.equals(Queue.class)) continue;
                return (Collection)InstanceUtils.newInstance(config.getQueueClass());
            }
            clazz = clazz.getSuperclass();
        }
        throw new BeanCopyException("Cannot new instance for collection for " + paramClazz.getSimpleName());
    }

    public static <T> T newInstance(Class<T> targetClass) {
        T targetObject = null;
        try {
            targetObject = targetClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (targetObject == null) {
            try {
                Constructor<T> con = targetClass.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                targetObject = con.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BeanCopyException("beanCopy new instance", e);
            }
        }
        return targetObject;
    }

    public static <T> Collection<T> unsafeCopyCollection(Object sourceObject, Class<T> targetClass, Class<?> optionClass, Class<?> collectionClass, CopyFeature[] features) {
        if (sourceObject == null) {
            return null;
        }
        boolean enumThrowsException = true;
        boolean useObjectToStringCopy = false;
        for (CopyFeature feature : features) {
            if (feature == CopyFeature.IGNORE_ENUM_CONVERT_EXCEPTION) {
                enumThrowsException = false;
                continue;
            }
            if (feature != CopyFeature.ENABLE_JAVA_BEAN_TO_STRING) continue;
            useObjectToStringCopy = true;
        }
        if (sourceObject instanceof Collection) {
            Collection sourceList = (Collection)sourceObject;
            Collection dataList = InstanceUtils.newCollection(collectionClass);
            if (targetClass.equals(String.class) && useObjectToStringCopy) {
                for (Object sourceObj : sourceList) {
                    dataList.add(sourceObj != null ? sourceObj.toString() : null);
                }
                return dataList;
            }
            if (targetClass.isEnum()) {
                for (Object sourceObj : sourceList) {
                    dataList.add(InstanceUtils.getEnumValue(sourceObj, targetClass, enumThrowsException));
                }
                return dataList;
            }
            return BeanCopyUtils.copyCollection((Collection)sourceObject, targetClass, optionClass);
        }
        if (sourceObject.getClass().isArray()) {
            Class<T> newInst;
            int i;
            BeanCopyDump.beginDump();
            int count = Array.getLength(sourceObject);
            Collection dataList = InstanceUtils.newCollection(collectionClass);
            if (targetClass.equals(String.class) && useObjectToStringCopy) {
                for (i = 0; i < count; ++i) {
                    newInst = Array.get(sourceObject, i);
                    dataList.add(newInst != null ? ((Object)newInst).toString() : null);
                }
            } else if (targetClass.isEnum()) {
                for (i = 0; i < count; ++i) {
                    newInst = Array.get(sourceObject, i);
                    dataList.add(InstanceUtils.getEnumValue(newInst, targetClass, enumThrowsException));
                }
            } else if (PropertyUtils.isPrimitive(sourceObject.getClass().getComponentType())) {
                for (i = 0; i < count; ++i) {
                    newInst = Array.get(sourceObject, i);
                    dataList.add(newInst);
                }
            } else {
                for (i = 0; i < count; ++i) {
                    newInst = BeanCopyUtils.copyBean(Array.get(sourceObject, i), targetClass, optionClass);
                    dataList.add(newInst);
                }
            }
            BeanCopyDump.endDump();
            return dataList;
        }
        return null;
    }

    private static <T> T getEnumValue(Object sourceObj, Class<T> targetClass, boolean enumThrowsException) {
        Enum[] enums;
        if (sourceObj == null) {
            return null;
        }
        if (enumThrowsException) {
            Class<T> target = targetClass;
            return Enum.valueOf(target, sourceObj.toString());
        }
        for (Enum enumKey : enums = (Enum[])targetClass.getEnumConstants()) {
            if (!enumKey.name().equals(sourceObj.toString())) continue;
            return (T)enumKey;
        }
        return null;
    }

    public static Object unsafeCopyArray(Object sourceObject, Class<?> targetClassType, Class<?> optionClass, CopyFeature[] features) {
        if (sourceObject == null) {
            return null;
        }
        boolean enumThrowsException = true;
        boolean useObjectToStringCopy = false;
        for (CopyFeature feature : features) {
            if (feature == CopyFeature.IGNORE_ENUM_CONVERT_EXCEPTION) {
                enumThrowsException = false;
                continue;
            }
            if (feature != CopyFeature.ENABLE_JAVA_BEAN_TO_STRING) continue;
            useObjectToStringCopy = true;
        }
        if (sourceObject instanceof Collection) {
            BeanCopyDump.beginDump();
            Collection collection = (Collection)sourceObject;
            Object retObject = Array.newInstance(targetClassType, collection.size());
            Iterator it = collection.iterator();
            int i = 0;
            if (targetClassType.equals(String.class) && useObjectToStringCopy) {
                while (it.hasNext()) {
                    Array.set(retObject, i++, it.next().toString());
                }
            } else if (targetClassType.isEnum()) {
                for (Object sourceObj : collection) {
                    Array.set(retObject, i++, InstanceUtils.getEnumValue(sourceObj, targetClassType, enumThrowsException));
                }
            } else if (PropertyUtils.isPrimitive(targetClassType)) {
                while (it.hasNext()) {
                    Array.set(retObject, i++, it.next());
                }
            } else {
                while (it.hasNext()) {
                    Class<?> newInst = BeanCopyUtils.copyBean(it.next(), targetClassType, optionClass);
                    Array.set(retObject, i++, newInst);
                }
            }
            BeanCopyDump.endDump();
            return retObject;
        }
        if (sourceObject.getClass().isArray()) {
            Object newInst;
            int i;
            BeanCopyDump.beginDump();
            int count = Array.getLength(sourceObject);
            Object retObject = Array.newInstance(targetClassType, count);
            if (targetClassType.equals(String.class) && useObjectToStringCopy) {
                for (i = 0; i < count; ++i) {
                    Array.set(retObject, i, Array.get(sourceObject, i) != null ? Array.get(sourceObject, i).toString() : null);
                }
            } else if (targetClassType.isEnum()) {
                for (i = 0; i < count; ++i) {
                    newInst = InstanceUtils.getEnumValue(Array.get(sourceObject, i), targetClassType, enumThrowsException);
                    Array.set(retObject, i, newInst);
                }
            } else {
                for (i = 0; i < count; ++i) {
                    newInst = BeanCopyUtils.copyBean(Array.get(sourceObject, i), targetClassType, optionClass);
                    Array.set(retObject, i, newInst);
                }
            }
            BeanCopyDump.endDump();
            return retObject;
        }
        return null;
    }
}

