/*
 * Decompiled with CFR 0.152.
 */
package com.tuyang.beanutils.internal.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class PropertyUtils {
    private static Map<Class<?>, WeakReference<PropertyDescriptor[]>> cacheMap = new HashMap();
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        PropertyDescriptor[] allPds = null;
        PropertyDescriptor[] propertyDescriptorArray = cacheMap;
        synchronized (cacheMap) {
            WeakReference<PropertyDescriptor[]> pdsRef = cacheMap.get(clazz);
            if (pdsRef != null) {
                allPds = (PropertyDescriptor[])pdsRef.get();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (allPds == null) {
                allPds = PropertyUtils.getPropertyDescriptors(clazz);
            }
            for (PropertyDescriptor pd : allPds) {
                if (!propertyName.equals(pd.getName())) continue;
                return pd;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        PropertyDescriptor[] allPds = null;
        Map<Class<?>, WeakReference<PropertyDescriptor[]>> map = cacheMap;
        synchronized (map) {
            WeakReference<PropertyDescriptor[]> pdsRef = cacheMap.get(clazz);
            if (pdsRef != null && (allPds = (PropertyDescriptor[])pdsRef.get()) != null) {
                return allPds;
            }
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            allPds = beanInfo.getPropertyDescriptors();
            Map<Class<?>, WeakReference<PropertyDescriptor[]>> map2 = cacheMap;
            synchronized (map2) {
                cacheMap.put(clazz, new WeakReference<PropertyDescriptor[]>(allPds));
            }
            return allPds;
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
    }

    public static Field getClassField(Class<?> targetClass, Class<?> optionClass, String propertyName) {
        Field propertyField = null;
        if (optionClass != null) {
            try {
                propertyField = optionClass.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (propertyField == null) {
            for (Class<?> tryClass = targetClass; tryClass != null; tryClass = tryClass.getSuperclass()) {
                try {
                    propertyField = tryClass.getDeclaredField(propertyName);
                    return propertyField;
                }
                catch (NoSuchFieldException | SecurityException e) {
                    continue;
                }
            }
        }
        return propertyField;
    }

    public static boolean isInterfaceType(Class<?> classType, Class<?> interfaceType) {
        if (classType.equals(interfaceType)) {
            return true;
        }
        while (classType != null) {
            Class<?>[] interfaces;
            for (Class<?> interClass : interfaces = classType.getInterfaces()) {
                if (!interClass.equals(interfaceType)) continue;
                return true;
            }
            classType = classType.getSuperclass();
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> classType) {
        if (classType.isPrimitive()) {
            return true;
        }
        for (Class<?> resolvedWrapper : primitiveWrapperTypeMap.keySet()) {
            if (!classType.equals(resolvedWrapper)) continue;
            return true;
        }
        return classType.equals(String.class);
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Class<?> resolvedPrimitive;
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        return lhsType.isPrimitive() ? lhsType == (resolvedPrimitive = primitiveWrapperTypeMap.get(rhsType)) : rhsType.isPrimitive() && rhsType == (resolvedPrimitive = primitiveWrapperTypeMap.get(lhsType));
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
    }
}

