/*
 * Decompiled with CFR 0.152.
 */
package org.zxhtom.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zxhtom.Exception.CommonException;
import org.zxhtom.adapter.PathAdapter;
import org.zxhtom.base.LicenseFactory;

public class TransformOffice {
    private Logger logger = LogManager.getLogger(TransformOffice.class);

    public boolean doTransform(String source, String target) {
        long old = System.currentTimeMillis();
        PathAdapter adapter = new PathAdapter();
        File file = new File(target);
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            Class<?> classByPath = adapter.getClassByPath(source);
            LicenseFactory.getInstance().isPassLicense(Class.forName(adapter.getLicensePath(source)));
            Constructor<?> constructor = classByPath.getConstructor(String.class);
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(source);
            Method method = classByPath.getMethod("save", OutputStream.class, Integer.TYPE);
            method.invoke(instance, outputStream, adapter.getFormatByPath(target));
            outputStream.close();
            long now = System.currentTimeMillis();
            this.logger.info("\u5171\u8017\u65f6\uff1a" + (double)(now - old) / 1000.0 + "\u79d2");
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)e);
        }
        catch (CommonException e) {
            this.logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            this.logger.error((Object)e);
        }
        catch (SecurityException e) {
            this.logger.error((Object)e);
        }
        catch (InstantiationException e) {
            this.logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getTargetException() + String.format(" : params (%1$s or %2$s) is not avalid ", source, target));
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return false;
    }
}

