/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HttpMethodEnum;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import shade.okhttp3.Dispatcher;
import shade.okhttp3.Dns;
import shade.okhttp3.OkHttpClient;
import shade.okhttp3.Request;
import shade.okhttp3.RequestBody;

public class RestConnectionService {
    private static final ILogger log = LoggerBuilder.getLogger(RestConnectionService.class);
    protected OkHttpClient httpClient;
    protected ObsProperties obsProperties;
    protected KeyManagerFactory keyManagerFactory;
    protected TrustManagerFactory trustManagerFactory;
    protected Semaphore semaphore;
    protected AtomicBoolean shuttingDown = new AtomicBoolean(false);
    protected volatile ProviderCredentials credentials;

    protected void initHttpClient(Dispatcher httpDispatcher, Dns customizedDnsImpl) {
        OkHttpClient.Builder builder = RestUtils.initHttpClientBuilder(this.obsProperties, this.keyManagerFactory, this.trustManagerFactory, httpDispatcher, customizedDnsImpl, this.credentials.getSecureRandom());
        if (this.obsProperties.getBoolProperty("httpclient.proxy-enable", true)) {
            String proxyHostAddress = this.obsProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.obsProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.obsProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.obsProperties.getStringProperty("httpclient.proxy-password", null);
            RestUtils.initHttpProxy(builder, proxyHostAddress, proxyPort, proxyUser, proxyPassword);
        }
        this.httpClient = builder.build();
        int maxConnections = this.obsProperties.getIntProperty("httpclient.max-connections", 1000);
        this.semaphore = new Semaphore(maxConnections);
    }

    protected void shutdown() {
        this.shutdownImpl();
    }

    protected void shutdownImpl() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            this.credentials = null;
            this.obsProperties = null;
            if (this.httpClient != null) {
                this.invokeShutdown();
                if (this.httpClient.connectionPool() != null) {
                    this.httpClient.connectionPool().evictAll();
                }
                this.httpClient = null;
            }
        }
    }

    private void invokeShutdown() {
        block3: {
            try {
                Method m;
                Object exeService;
                Method dispatcherMethod = this.httpClient.getClass().getMethod("dispatcher", new Class[0]);
                if (dispatcherMethod != null && (exeService = (m = dispatcherMethod.invoke((Object)this.httpClient, new Object[0]).getClass().getDeclaredMethod("executorService", new Class[0])).invoke((Object)this.httpClient.dispatcher(), new Object[0])) instanceof ExecutorService) {
                    ExecutorService executorService = (ExecutorService)exeService;
                    executorService.shutdown();
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("shows some exceptions at the time of shutdown httpClient. ", e);
            }
        }
    }

    protected Request.Builder setupConnection(NewTransResult result, boolean isOEF, boolean isListBuckets) throws ServiceException {
        boolean pathStyle = this.isPathStyle();
        String endPoint = this.getEndpoint();
        boolean isCname = this.isCname();
        String hostname = isCname || isListBuckets ? endPoint : ServiceUtils.generateHostnameForBucket(RestUtils.encodeUrlString(result.getBucketName()), pathStyle, endPoint);
        String resourceString = "/";
        if (hostname.equals(endPoint) && !isCname && result.getBucketName() != null && !result.getBucketName().isEmpty()) {
            resourceString = resourceString + RestUtils.encodeUrlString(result.getBucketName());
        }
        if (result.getObjectKey() != null) {
            resourceString = result.isEncodeUrl() ? resourceString + (pathStyle && !isCname ? "/" : "") + RestUtils.encodeUrlString(result.getObjectKey()) : resourceString + result.getObjectKey();
        }
        String url = this.addProtocol(hostname, resourceString);
        url = this.addRequestParametersToUrlPath(url, result.getParams(), isOEF);
        Request.Builder builder = this.createRequestBuilder(result.getHttpMethod(), result.getBody(), url);
        return builder;
    }

    private Request.Builder createRequestBuilder(HttpMethodEnum method, RequestBody body, String url) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (body == null) {
            body = RequestBody.create("", null);
        }
        switch (method) {
            case PUT: {
                builder.put(body);
                break;
            }
            case POST: {
                builder.post(body);
                break;
            }
            case HEAD: {
                builder.head();
                break;
            }
            case GET: {
                builder.get();
                break;
            }
            case DELETE: {
                builder.delete(body);
                break;
            }
            case OPTIONS: {
                builder.method("OPTIONS", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised HTTP method name: " + (Object)((Object)method));
            }
        }
        if (!this.isKeepAlive()) {
            builder.addHeader("Connection", "Close");
        }
        return builder;
    }

    private String addProtocol(String hostname, String resourceString) {
        String url = null;
        if (this.getHttpsOnly()) {
            int securePort = this.getHttpsPort();
            String securePortStr = securePort == 443 ? "" : ":" + securePort;
            url = "https://" + hostname + securePortStr + resourceString;
        } else {
            int insecurePort = this.getHttpPort();
            String insecurePortStr = insecurePort == 80 ? "" : ":" + insecurePort;
            url = "http://" + hostname + insecurePortStr + resourceString;
        }
        if (log.isDebugEnabled()) {
            log.debug("OBS URL: " + url);
        }
        return url;
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map<String, String> requestParameters, boolean isOEF) throws ServiceException {
        StringBuilder urlPathBuilder = new StringBuilder(urlPath);
        if (requestParameters != null) {
            for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (isOEF) {
                    if (this.isPathStyle()) {
                        urlPathBuilder.append("/").append(key);
                    } else {
                        urlPathBuilder.append(key);
                    }
                } else {
                    urlPathBuilder.append(urlPathBuilder.indexOf("?") < 0 ? "?" : "&").append(RestUtils.encodeUrlString(key));
                }
                if (ServiceUtils.isValid(value)) {
                    urlPathBuilder.append("=").append(RestUtils.encodeUrlString(value));
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Added request parameter: " + key + "=" + ServiceUtils.getLoggableInfo(key, value));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Added request parameter without value: " + key);
            }
        }
        return urlPathBuilder.toString();
    }

    protected String getEndpoint() {
        return this.obsProperties.getStringProperty("obs-endpoint", "");
    }

    protected int getHttpPort() {
        return this.obsProperties.getIntProperty("obs-endpoint-http-port", 80);
    }

    protected int getHttpsPort() {
        return this.obsProperties.getIntProperty("obs-endpoint-https-port", 443);
    }

    protected boolean isKeepAlive() {
        return this.obsProperties.getBoolProperty("httpclient.keep-alive", true);
    }

    protected boolean isPathStyle() {
        return this.obsProperties.getBoolProperty("obs.disable-dns-buckets", false);
    }

    protected boolean isCname() {
        return this.obsProperties.getBoolProperty("httpclient.is-cname", false);
    }

    protected boolean getHttpsOnly() {
        return this.obsProperties.getBoolProperty("obs.https-only", true);
    }
}

