/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusEndpoint;
import org.tinyradius.util.RadiusException;

public class RadiusClient {
    private int authPort = 1812;
    private int acctPort = 1813;
    private String hostName = null;
    private String sharedSecret = null;
    private DatagramSocket socket = null;
    private int retryCount = 3;
    private int socketTimeout = 3000;
    private static Log logger = LogFactory.getLog(RadiusClient.class);

    public RadiusClient(String hostName, String sharedSecret) {
        this.setHostName(hostName);
        this.setSharedSecret(sharedSecret);
    }

    public RadiusClient(RadiusEndpoint client) {
        this(client.getEndpointAddress().getAddress().getHostAddress(), client.getSharedSecret());
    }

    public synchronized boolean authenticate(String userName, String password) throws IOException, RadiusException {
        AccessRequest request = new AccessRequest(userName, password);
        RadiusPacket response = this.authenticate(request);
        return response.getPacketType() == 2;
    }

    public synchronized RadiusPacket authenticate(AccessRequest request) throws IOException, RadiusException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("send Access-Request packet: " + request));
        }
        RadiusPacket response = this.communicate(request, this.getAuthPort());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("received packet: " + response));
        }
        return response;
    }

    public synchronized RadiusPacket account(AccountingRequest request) throws IOException, RadiusException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("send Accounting-Request packet: " + request));
        }
        RadiusPacket response = this.communicate(request, this.getAcctPort());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("received packet: " + response));
        }
        return response;
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setAuthPort(int authPort) {
        if (authPort < 1 || authPort > 65535) {
            throw new IllegalArgumentException("bad port number");
        }
        this.authPort = authPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        if (hostName == null || hostName.length() == 0) {
            throw new IllegalArgumentException("host name must not be empty");
        }
        this.hostName = hostName;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 1) {
            throw new IllegalArgumentException("retry count must be positive");
        }
        this.retryCount = retryCount;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        if (sharedSecret == null || sharedSecret.length() == 0) {
            throw new IllegalArgumentException("shared secret must not be empty");
        }
        this.sharedSecret = sharedSecret;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) throws SocketException {
        if (socketTimeout < 1) {
            throw new IllegalArgumentException("socket tiemout must be positive");
        }
        this.socketTimeout = socketTimeout;
        if (this.socket != null) {
            this.socket.setSoTimeout(socketTimeout);
        }
    }

    public void setAcctPort(int acctPort) {
        if (acctPort < 1 || acctPort > 65535) {
            throw new IllegalArgumentException("bad port number");
        }
        this.acctPort = acctPort;
    }

    public int getAcctPort() {
        return this.acctPort;
    }

    public RadiusPacket communicate(RadiusPacket request, int port) throws IOException, RadiusException {
        DatagramPacket packetIn = new DatagramPacket(new byte[4096], 4096);
        DatagramPacket packetOut = this.makeDatagramPacket(request, port);
        DatagramSocket socket = this.getSocket();
        for (int i = 1; i <= this.getRetryCount(); ++i) {
            try {
                socket.send(packetOut);
                socket.receive(packetIn);
                return this.makeRadiusPacket(packetIn, request);
            }
            catch (IOException ioex) {
                if (i == this.getRetryCount()) {
                    if (logger.isErrorEnabled()) {
                        if (ioex instanceof SocketTimeoutException) {
                            logger.error((Object)"communication failure (timeout), no more retries");
                        } else {
                            logger.error((Object)"communication failure, no more retries", (Throwable)ioex);
                        }
                    }
                    throw ioex;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("communication failure, retry " + i));
                continue;
            }
        }
        return null;
    }

    public static RadiusPacket communicate(RadiusEndpoint remoteServer, RadiusPacket request) throws RadiusException, IOException {
        RadiusClient rc = new RadiusClient(remoteServer);
        return rc.communicate(request, remoteServer.getEndpointAddress().getPort());
    }

    protected DatagramSocket getSocket() throws SocketException {
        if (this.socket == null) {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(this.getSocketTimeout());
        }
        return this.socket;
    }

    protected DatagramPacket makeDatagramPacket(RadiusPacket packet, int port) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        packet.encodeRequestPacket(bos, this.getSharedSecret());
        byte[] data = bos.toByteArray();
        InetAddress address = InetAddress.getByName(this.getHostName());
        DatagramPacket datagram = new DatagramPacket(data, data.length, address, port);
        return datagram;
    }

    protected RadiusPacket makeRadiusPacket(DatagramPacket packet, RadiusPacket request) throws IOException, RadiusException {
        ByteArrayInputStream in = new ByteArrayInputStream(packet.getData());
        return RadiusPacket.decodeResponsePacket(in, this.getSharedSecret(), request);
    }
}

