/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;

public class IfStatement
extends Statement {
    public Expression condtion;
    public Statement ifStatement;
    public Statement elseStatement;

    public IfStatement(Expression condtion, Statement ifStatement, Statement elseStatement, GrammarToken token) {
        super(token);
        this.condtion = condtion;
        this.ifStatement = ifStatement;
        this.elseStatement = elseStatement;
    }

    @Override
    public void execute(Context ctx) {
        Object value = this.condtion.evaluate(ctx);
        if (ALU.isTrue(value, this).booleanValue()) {
            this.ifStatement.execute(ctx);
        } else if (this.elseStatement != null) {
            this.elseStatement.execute(ctx);
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.condtion.infer(inferCtx);
        this.ifStatement.infer(inferCtx);
        if (this.elseStatement != null) {
            this.elseStatement.infer(inferCtx);
        }
    }
}

