/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.data;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataAddressException;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataValueException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Observable;

public abstract class ModbusValues<T>
extends Observable
implements Iterable<T> {
    public abstract int getQuantity();

    public abstract T get(int var1) throws IllegalDataAddressException;

    public abstract void setImpl(int var1, T var2) throws IllegalDataAddressException, IllegalDataValueException;

    public abstract int getByteCount();

    public abstract byte[] getBytes();

    public abstract void setBytesBe(byte[] var1);

    public final void set(int offset, T value) throws IllegalDataAddressException, IllegalDataValueException {
        this.setImpl(offset, value);
        this.notifyObservers(new int[]{offset, 1});
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ModbusValues.this.getQuantity();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    try {
                        return ModbusValues.this.get(this.index++);
                    }
                    catch (IllegalDataAddressException e) {
                        Modbus.log().severe(this.getClass().getSimpleName() + " " + e.getLocalizedMessage() + ": quantity = " + ModbusValues.this.getQuantity() + ", index = " + this.index);
                        throw new NoSuchElementException();
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };
    }
}

