/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractWriteResponse
extends ModbusResponse {
    private int startAddress = 0;

    protected AbstractWriteResponse() {
    }

    @Override
    protected final void readResponse(ModbusInputStream fifo) throws IOException {
        try {
            this.setStartAddress(fifo.readShortBE());
        }
        catch (ModbusNumberException e) {
            e.printStackTrace();
        }
        this.readValue(fifo);
    }

    @Override
    public final void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getStartAddress());
        this.writeValue(fifo);
    }

    protected abstract void readValue(ModbusInputStream var1) throws IOException;

    protected abstract void writeValue(ModbusOutputStream var1) throws IOException;

    public final int getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(int startAddress) throws ModbusNumberException {
        if (!Modbus.checkStartAddress(startAddress)) {
            throw new ModbusNumberException("Error in start address", startAddress);
        }
        this.startAddress = startAddress;
    }

    @Override
    protected final int responseSize() {
        return 4;
    }
}

