/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadHoldingRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteMultipleRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadWriteMultipleRegistersRequest
extends ModbusRequest {
    private final ReadHoldingRegistersRequest reader = new ReadHoldingRegistersRequest();
    private final WriteMultipleRegistersRequest writer = new WriteMultipleRegistersRequest();

    @Override
    protected Class getResponseClass() {
        return ReadWriteMultipleRegistersResponse.class;
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        this.reader.writeRequest(fifo);
        this.writer.writeRequest(fifo);
    }

    @Override
    public int requestSize() {
        return this.reader.requestSize() + this.writer.requestSize();
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadWriteMultipleRegistersResponse response = (ReadWriteMultipleRegistersResponse)this.getResponse();
        try {
            dataHolder.writeHoldingRegisterRange(this.writer.getStartAddress(), this.writer.getRegisters());
            int[] range = dataHolder.readHoldingRegisterRange(this.reader.getStartAddress(), this.reader.getQuantity());
            response.setBuffer(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadWriteMultipleRegistersResponse)) {
            return false;
        }
        ReadWriteMultipleRegistersResponse r = (ReadWriteMultipleRegistersResponse)response;
        return r.getByteCount() == this.reader.getQuantity() * 2;
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        this.reader.readPDU(fifo);
        this.writer.readPDU(fifo);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_WRITE_MULTIPLE_REGISTERS.toInt();
    }

    @Override
    public void setServerAddress(int serverAddress) throws ModbusNumberException {
        super.setServerAddress(serverAddress);
        this.reader.setServerAddress(serverAddress);
        this.writer.setServerAddress(serverAddress);
    }

    public int getReadAddress() {
        return this.reader.getStartAddress();
    }

    public void setReadAddress(int address) throws ModbusNumberException {
        this.reader.setStartAddress(address);
    }

    public int getReadQuantity() {
        return this.reader.getQuantity();
    }

    public void setReadQuantity(int quantity) throws ModbusNumberException {
        this.reader.setQuantity(quantity);
    }

    public void setWriteAddress(int address) throws ModbusNumberException {
        this.writer.setStartAddress(address);
    }

    public void setWriteRegisters(int[] registers) throws ModbusNumberException {
        this.writer.setRegisters(registers);
    }
}

