/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractReadResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;

public final class ReportSlaveIdResponse
extends AbstractReadResponse {
    private byte[] slaveId;

    public byte[] getSlaveId() {
        return this.slaveId != null ? Arrays.copyOf(this.slaveId, this.slaveId.length) : new byte[]{};
    }

    public void setSlaveId(byte[] slaveId) throws ModbusNumberException {
        if (slaveId.length + 2 > 254) {
            throw new ModbusNumberException("Slave Id greater than max pdu length: ", this.getByteCount());
        }
        this.setByteCount(slaveId.length);
        this.slaveId = Arrays.copyOf(slaveId, slaveId.length);
    }

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException {
        if (254 < this.responseSize()) {
            throw new IOException("Slave Id greater than max pdu length: " + this.getByteCount());
        }
        this.slaveId = new byte[this.getByteCount()];
        int size = fifo.read(this.slaveId);
        if (size < this.slaveId.length) {
            Modbus.log().warning(this.slaveId.length + " bytes expected, but " + size + " received.");
        }
    }

    @Override
    protected void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.slaveId);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.REPORT_SLAVE_ID.toInt();
    }
}

