/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractWriteResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class WriteSingleRegisterResponse
extends AbstractWriteResponse {
    int value;

    @Override
    protected final void readValue(ModbusInputStream fifo) throws IOException {
        try {
            this.setValue(fifo.readShortBE());
        }
        catch (ModbusNumberException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected final void writeValue(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getValue());
    }

    protected boolean checkValue() {
        return Modbus.checkRegisterValue(this.getValue());
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_SINGLE_REGISTER.toInt();
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int value) throws ModbusNumberException {
        this.value = (short)value & 0xFFFF;
        if (!this.checkValue()) {
            throw new ModbusNumberException("Error in register value", value);
        }
    }
}

